/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.ImmediateScheduler;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Action1;

public final class OperationToObservableIterable<T> {
    public static <T> Observable.OnSubscribeFunc<T> toObservableIterable(Iterable<? extends T> list, Scheduler scheduler) {
        if (scheduler instanceof ImmediateScheduler) {
            return new ToObservableIterable<T>(list);
        }
        return new ToObservableIterableScheduled<T>(list, scheduler);
    }

    public static <T> Observable.OnSubscribeFunc<T> toObservableIterable(Iterable<? extends T> list) {
        return new ToObservableIterable<T>(list);
    }

    private static class ToObservableIterable<T>
    implements Observable.OnSubscribeFunc<T> {
        final Iterable<? extends T> iterable;

        public ToObservableIterable(Iterable<? extends T> list) {
            this.iterable = list;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            try {
                for (T t : this.iterable) {
                    observer.onNext(t);
                }
                observer.onCompleted();
            }
            catch (Exception e) {
                observer.onError(e);
            }
            return Subscriptions.empty();
        }
    }

    private static class ToObservableIterableScheduled<T>
    implements Observable.OnSubscribeFunc<T> {
        Scheduler scheduler;
        final Iterable<? extends T> iterable;

        public ToObservableIterableScheduled(Iterable<? extends T> list, Scheduler scheduler) {
            this.iterable = list;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final Iterator<? extends T> iterator = this.iterable.iterator();
            return this.scheduler.schedule(new Action1<Action0>(){

                @Override
                public void call(Action0 self) {
                    try {
                        if (iterator.hasNext()) {
                            Object x = iterator.next();
                            observer.onNext(x);
                            self.call();
                        } else {
                            observer.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        observer.onError(e);
                    }
                }
            });
        }
    }
}

