/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Functions;

public final class OperationZip {
    public static <T1, T2, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6, o7), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6, o7, o8), Functions.fromFunc(zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable.OnSubscribeFunc<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return OperationZip.zip(Arrays.asList(o1, o2, o3, o4, o5, o6, o7, o8, o9), Functions.fromFunc(zipFunction));
    }

    public static <R> Observable.OnSubscribeFunc<R> zip(Iterable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        ManyObservables a = new ManyObservables(ws, zipFunction);
        return a;
    }

    public static <T, U, R> Observable.OnSubscribeFunc<R> zipIterable(Observable<? extends T> source, Iterable<? extends U> other, Func2<? super T, ? super U, ? extends R> zipFunction) {
        return new ZipIterable<T, U, R>(source, other, zipFunction);
    }

    private static final class ZipIterable<T, U, R>
    implements Observable.OnSubscribeFunc<R> {
        final Observable<? extends T> source;
        final Iterable<? extends U> other;
        final Func2<? super T, ? super U, ? extends R> zipFunction;

        public ZipIterable(Observable<? extends T> source, Iterable<? extends U> other, Func2<? super T, ? super U, ? extends R> zipFunction) {
            this.source = source;
            this.other = other;
            this.zipFunction = zipFunction;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> t1) {
            boolean first;
            Iterator<U> it;
            try {
                it = this.other.iterator();
                first = it.hasNext();
            }
            catch (Throwable t) {
                t1.onError(t);
                return Subscriptions.empty();
            }
            if (!first) {
                t1.onCompleted();
                return Subscriptions.empty();
            }
            SerialSubscription ssub = new SerialSubscription();
            ssub.set(this.source.subscribe(new SourceObserver<T, U, R>(t1, it, this.zipFunction, ssub)));
            return ssub;
        }

        private static final class SourceObserver<T, U, R>
        implements Observer<T> {
            final Observer<? super R> observer;
            final Iterator<? extends U> other;
            final Func2<? super T, ? super U, ? extends R> zipFunction;
            final Subscription cancel;

            public SourceObserver(Observer<? super R> observer, Iterator<? extends U> other, Func2<? super T, ? super U, ? extends R> zipFunction, Subscription cancel) {
                this.observer = observer;
                this.other = other;
                this.zipFunction = zipFunction;
                this.cancel = cancel;
            }

            @Override
            public void onNext(T args) {
                boolean has;
                R r;
                U u = this.other.next();
                try {
                    r = this.zipFunction.call(args, u);
                }
                catch (Throwable t) {
                    this.onError(t);
                    return;
                }
                this.observer.onNext(r);
                try {
                    has = this.other.hasNext();
                }
                catch (Throwable t) {
                    this.onError(t);
                    return;
                }
                if (!has) {
                    this.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e) {
                this.observer.onError(e);
                this.cancel.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.observer.onCompleted();
                this.cancel.unsubscribe();
            }
        }
    }

    private static final class ManyObservables<T, U>
    implements Observable.OnSubscribeFunc<U> {
        protected final Iterable<? extends Observable<? extends T>> sources;
        protected final FuncN<? extends U> selector;

        public ManyObservables(Iterable<? extends Observable<? extends T>> sources, FuncN<? extends U> selector) {
            this.sources = sources;
            this.selector = selector;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super U> observer) {
            CompositeSubscription composite = new CompositeSubscription(new Subscription[0]);
            ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
            ArrayList all = new ArrayList();
            Observer o2 = new Observer<List<T>>(){

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable t) {
                    observer.onError(t);
                }

                @Override
                public void onNext(List<T> value) {
                    observer.onNext(ManyObservables.this.selector.call(value.toArray(new Object[value.size()])));
                }
            };
            for (Observable<? extends T> observable : this.sources) {
                ItemObserver<? extends T> io = new ItemObserver<T>(rwLock, all, observable, o2, composite);
                composite.add(io);
                all.add(io);
            }
            for (ItemObserver itemObserver : all) {
                itemObserver.connect();
            }
            return composite;
        }

        private static final class ItemObserver<T>
        implements Observer<T>,
        Subscription {
            protected final ReadWriteLock rwLock;
            public final Queue<Object> queue = new LinkedList<Object>();
            public final List<ItemObserver<T>> all;
            protected static final Object NULL_SENTINEL = new Object();
            protected final Subscription cancel;
            protected final SerialSubscription toSource = new SerialSubscription();
            protected boolean done;
            protected final Observable<? extends T> source;
            protected final Observer<? super List<T>> observer;

            public ItemObserver(ReadWriteLock rwLock, List<ItemObserver<T>> all, Observable<? extends T> source, Observer<? super List<T>> observer, Subscription cancel) {
                this.rwLock = rwLock;
                this.all = all;
                this.source = source;
                this.observer = observer;
                this.cancel = cancel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNext(T value) {
                this.rwLock.readLock().lock();
                try {
                    if (this.done) {
                        return;
                    }
                    this.queue.add(value != null ? value : NULL_SENTINEL);
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
                if (this.rwLock.writeLock().tryLock()) {
                    try {
                        while (true) {
                            ArrayList<Object> values = new ArrayList<Object>(this.all.size());
                            for (ItemObserver<T> io : this.all) {
                                if (io.queue.isEmpty()) {
                                    if (!io.done) continue;
                                    this.observer.onCompleted();
                                    this.cancel.unsubscribe();
                                    return;
                                }
                                Object v = io.queue.peek();
                                if (v == NULL_SENTINEL) {
                                    v = null;
                                }
                                values.add(v);
                            }
                            if (values.size() == this.all.size()) {
                                for (ItemObserver<T> io : this.all) {
                                    io.queue.poll();
                                }
                                this.observer.onNext(values);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable ex) {
                boolean c = false;
                this.rwLock.writeLock().lock();
                try {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    c = true;
                    this.observer.onError(ex);
                    this.cancel.unsubscribe();
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
                if (c) {
                    this.unsubscribe();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted() {
                boolean c = false;
                this.rwLock.readLock().lock();
                try {
                    this.done = true;
                    c = true;
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
                if (this.rwLock.writeLock().tryLock()) {
                    try {
                        for (ItemObserver<T> io : this.all) {
                            if (!io.queue.isEmpty() || !io.done) continue;
                            this.observer.onCompleted();
                            this.cancel.unsubscribe();
                            return;
                        }
                    }
                    finally {
                        this.rwLock.writeLock().unlock();
                    }
                }
                if (c) {
                    this.unsubscribe();
                }
            }

            public void connect() {
                this.toSource.setSubscription(this.source.subscribe(this));
            }

            @Override
            public void unsubscribe() {
                this.toSource.unsubscribe();
            }
        }
    }
}

