/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.DiscardableAction;
import rx.schedulers.SleepingAction;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

public class CurrentThreadScheduler
extends Scheduler {
    private static final CurrentThreadScheduler INSTANCE = new CurrentThreadScheduler();
    private static final AtomicLong counter = new AtomicLong(0L);
    private static final ThreadLocal<PriorityQueue<TimedAction>> QUEUE = new ThreadLocal<PriorityQueue<TimedAction>>(){

        @Override
        protected PriorityQueue<TimedAction> initialValue() {
            return new PriorityQueue<TimedAction>();
        }
    };
    private static final ThreadLocal<Boolean> PROCESSING = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public static CurrentThreadScheduler getInstance() {
        return INSTANCE;
    }

    CurrentThreadScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        InnerCurrentThreadScheduler innerScheduler = new InnerCurrentThreadScheduler();
        innerScheduler.schedule(state, action);
        this.enqueueFromOuter(innerScheduler, this.now());
        return innerScheduler;
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
        long execTime = this.now() + unit.toMillis(delayTime);
        InnerCurrentThreadScheduler innerScheduler = new InnerCurrentThreadScheduler();
        innerScheduler.schedule(state, action, delayTime, unit);
        this.enqueueFromOuter(innerScheduler, execTime);
        return innerScheduler;
    }

    private void enqueueFromOuter(final InnerCurrentThreadScheduler innerScheduler, long execTime) {
        PriorityQueue<TimedAction> queue = QUEUE.get();
        queue.add(new TimedAction(new Func1<Scheduler, Subscription>(){

            @Override
            public Subscription call(Scheduler _) {
                return innerScheduler.startProcessing();
            }
        }, execTime, counter.incrementAndGet()));
        if (!PROCESSING.get().booleanValue()) {
            PROCESSING.set(Boolean.TRUE);
            while (!queue.isEmpty()) {
                queue.poll().action.call(innerScheduler);
            }
            PROCESSING.set(Boolean.FALSE);
        }
    }

    private static class TimedAction
    implements Comparable<TimedAction> {
        final Func1<Scheduler, Subscription> action;
        final Long execTime;
        final Long count;

        private TimedAction(Func1<Scheduler, Subscription> action, Long execTime, Long count) {
            this.action = action;
            this.execTime = execTime;
            this.count = count;
        }

        @Override
        public int compareTo(TimedAction that) {
            int result = this.execTime.compareTo(that.execTime);
            if (result == 0) {
                return this.count.compareTo(that.count);
            }
            return result;
        }
    }

    private static class InnerCurrentThreadScheduler
    extends Scheduler
    implements Subscription {
        private final MultipleAssignmentSubscription childSubscription = new MultipleAssignmentSubscription();
        private final PriorityQueue<TimedAction> innerQueue = new PriorityQueue();

        private InnerCurrentThreadScheduler() {
        }

        @Override
        public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
            DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
            this.childSubscription.set(discardableAction);
            this.enqueue(discardableAction, this.now());
            return this.childSubscription;
        }

        @Override
        public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
            long execTime = this.now() + unit.toMillis(delayTime);
            DiscardableAction<T> discardableAction = new DiscardableAction<T>(state, new SleepingAction<T>(action, this, execTime));
            this.childSubscription.set(discardableAction);
            this.enqueue(discardableAction, execTime);
            return this.childSubscription;
        }

        private void enqueue(Func1<Scheduler, Subscription> action, long execTime) {
            this.innerQueue.add(new TimedAction(action, execTime, counter.incrementAndGet()));
        }

        private Subscription startProcessing() {
            while (!this.innerQueue.isEmpty()) {
                this.innerQueue.poll().action.call(this);
            }
            return this;
        }

        @Override
        public void unsubscribe() {
            this.childSubscription.unsubscribe();
        }
    }
}

