/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func1;
import rx.util.functions.Func2;

class DiscardableAction<T>
implements Func1<Scheduler, Subscription>,
Subscription {
    private final Func2<? super Scheduler, ? super T, ? extends Subscription> underlying;
    private final T state;
    private final SafeObservableSubscription wrapper = new SafeObservableSubscription();
    private final AtomicBoolean ready = new AtomicBoolean(true);

    public DiscardableAction(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> underlying) {
        this.state = state;
        this.underlying = underlying;
    }

    @Override
    public Subscription call(Scheduler scheduler) {
        if (this.ready.compareAndSet(true, false)) {
            Subscription subscription = this.underlying.call(scheduler, this.state);
            this.wrapper.wrap(subscription);
            return subscription;
        }
        return this.wrapper;
    }

    @Override
    public void unsubscribe() {
        this.ready.set(false);
        this.wrapper.unsubscribe();
    }
}

