/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.DiscardableAction;
import rx.schedulers.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Func2;

public class ExecutorScheduler
extends Scheduler {
    private final Executor executor;

    public ExecutorScheduler(Executor executor) {
        this.executor = executor;
    }

    public ExecutorScheduler(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public <T> Subscription schedulePeriodically(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long initialDelay, long period, TimeUnit unit) {
        if (this.executor instanceof ScheduledExecutorService) {
            final CompositeSubscription subscriptions = new CompositeSubscription(new Subscription[0]);
            ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Subscription s = (Subscription)action.call(ExecutorScheduler.this, state);
                    subscriptions.add(s);
                }
            }, initialDelay, period, unit);
            subscriptions.add(Subscriptions.from(f));
            return subscriptions;
        }
        return super.schedulePeriodically(state, action, initialDelay, period, unit);
    }

    @Override
    public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
        final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
        final InnerExecutorScheduler _scheduler = new InnerExecutorScheduler(this.executor);
        CompositeSubscription subscription = new CompositeSubscription(discardableAction, _scheduler);
        if (this.executor instanceof ScheduledExecutorService) {
            ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).schedule(new Runnable(){

                @Override
                public void run() {
                    discardableAction.call(_scheduler);
                }
            }, delayTime, unit);
            subscription.add(Subscriptions.from(f));
        } else {
            if (delayTime == 0L) {
                return this.schedule(state, action);
            }
            ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    _scheduler.schedule(state, action);
                }
            }, delayTime, unit);
            subscription.add(Subscriptions.from(f));
        }
        return subscription;
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
        final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
        s.add(discardableAction);
        final InnerExecutorScheduler _scheduler = new InnerExecutorScheduler(this.executor);
        s.add(_scheduler);
        s.add(ExecutorScheduler.execute(this.executor, new Runnable(){

            @Override
            public void run() {
                discardableAction.call(_scheduler);
            }
        }));
        return s;
    }

    private static Subscription execute(Executor executor, Runnable r) {
        if (executor instanceof ExecutorService) {
            Future<?> f = ((ExecutorService)executor).submit(r);
            return Subscriptions.from(f);
        }
        executor.execute(r);
        return Subscriptions.empty();
    }

    private static class InnerExecutorScheduler
    extends Scheduler
    implements Subscription {
        private final MultipleAssignmentSubscription childSubscription = new MultipleAssignmentSubscription();
        private final Executor executor;

        InnerExecutorScheduler(Executor executor) {
            this.executor = executor;
        }

        @Override
        public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
            if (this.childSubscription.isUnsubscribed()) {
                return this.childSubscription;
            }
            CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
            final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
            s.add(discardableAction);
            final InnerExecutorScheduler _scheduler = this;
            s.add(ExecutorScheduler.execute(this.executor, new Runnable(){

                @Override
                public void run() {
                    discardableAction.call(_scheduler);
                }
            }));
            this.childSubscription.set(s);
            return this.childSubscription;
        }

        @Override
        public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
            if (this.childSubscription.isUnsubscribed()) {
                return this.childSubscription;
            }
            CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
            final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
            s.add(discardableAction);
            final InnerExecutorScheduler _scheduler = this;
            if (this.executor instanceof ScheduledExecutorService) {
                ScheduledFuture<?> f = ((ScheduledExecutorService)this.executor).schedule(new Runnable(){

                    @Override
                    public void run() {
                        discardableAction.call(_scheduler);
                    }
                }, delayTime, unit);
                this.childSubscription.set(Subscriptions.from(f));
            } else {
                if (delayTime == 0L) {
                    return this.schedule(state, action);
                }
                ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                    @Override
                    public void run() {
                        _scheduler.schedule(state, action);
                    }
                }, delayTime, unit);
                this.childSubscription.set(Subscriptions.from(f));
            }
            return this.childSubscription;
        }

        @Override
        public void unsubscribe() {
            this.childSubscription.unsubscribe();
        }
    }
}

