/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class GenericScheduledExecutorService {
    private static final GenericScheduledExecutorService INSTANCE = new GenericScheduledExecutorService();
    private final ScheduledExecutorService executor;

    private GenericScheduledExecutorService() {
        int count = Runtime.getRuntime().availableProcessors();
        if (count > 8) {
            count /= 2;
        }
        if (count > 8) {
            count = 8;
        }
        this.executor = Executors.newScheduledThreadPool(count, new ThreadFactory(){
            final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "RxScheduledExecutorPool-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static ScheduledExecutorService getInstance() {
        return GenericScheduledExecutorService.INSTANCE.executor;
    }
}

