/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.SleepingAction;
import rx.util.functions.Func2;

public final class ImmediateScheduler
extends Scheduler {
    private static final ImmediateScheduler INSTANCE = new ImmediateScheduler();

    public static ImmediateScheduler getInstance() {
        return INSTANCE;
    }

    ImmediateScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        return action.call(this, state);
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long dueTime, TimeUnit unit) {
        long execTime = this.now() + unit.toMillis(dueTime);
        return this.schedule(state, new SleepingAction<T>(action, this, execTime));
    }
}

