/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Scheduler;
import rx.Subscription;
import rx.schedulers.DiscardableAction;
import rx.schedulers.GenericScheduledExecutorService;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.MultipleAssignmentSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;
import rx.util.functions.Func2;

public class NewThreadScheduler
extends Scheduler {
    private static final NewThreadScheduler INSTANCE = new NewThreadScheduler();
    private static final AtomicLong count = new AtomicLong();

    public static NewThreadScheduler getInstance() {
        return INSTANCE;
    }

    private NewThreadScheduler() {
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        final EventLoopScheduler s = new EventLoopScheduler();
        CompositeSubscription cs = new CompositeSubscription(new Subscription[0]);
        cs.add(s.schedule(state, action));
        cs.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                s.shutdownNow();
            }
        }));
        return cs;
    }

    @Override
    public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delay, TimeUnit unit) {
        final NewThreadScheduler _scheduler = this;
        final CompositeSubscription subscription = new CompositeSubscription(new Subscription[0]);
        ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

            @Override
            public void run() {
                if (!subscription.isUnsubscribed()) {
                    Subscription s = _scheduler.schedule(state, action);
                    subscription.add(s);
                }
            }
        }, delay, unit);
        subscription.add(Subscriptions.from(f));
        return subscription;
    }

    private static class EventLoopScheduler
    extends Scheduler {
        private final ExecutorService executor;
        private final MultipleAssignmentSubscription childSubscription = new MultipleAssignmentSubscription();

        private EventLoopScheduler() {
            this.executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "RxNewThreadScheduler-" + count.incrementAndGet());
                    t.setDaemon(true);
                    return t;
                }
            });
        }

        @Override
        public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
            if (this.childSubscription.isUnsubscribed()) {
                return this.childSubscription;
            }
            CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
            final DiscardableAction<? super T> discardableAction = new DiscardableAction<T>(state, action);
            s.add(discardableAction);
            final EventLoopScheduler _scheduler = this;
            s.add(Subscriptions.from(this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    discardableAction.call(_scheduler);
                }
            })));
            this.childSubscription.set(s);
            return this.childSubscription;
        }

        @Override
        public <T> Subscription schedule(final T state, final Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
            if (this.childSubscription.isUnsubscribed()) {
                return this.childSubscription;
            }
            final EventLoopScheduler _scheduler = this;
            final CompositeSubscription subscription = new CompositeSubscription(new Subscription[0]);
            ScheduledFuture<?> f = GenericScheduledExecutorService.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    if (!subscription.isUnsubscribed()) {
                        Subscription s = _scheduler.schedule(state, action);
                        subscription.add(s);
                    }
                }
            }, delayTime, unit);
            subscription.add(Subscriptions.from(f));
            return subscription;
        }

        private void shutdownNow() {
            this.executor.shutdownNow();
        }
    }
}

