/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import rx.Scheduler;
import rx.Subscription;
import rx.util.functions.Func2;

class SleepingAction<T>
implements Func2<Scheduler, T, Subscription> {
    private final Func2<? super Scheduler, ? super T, ? extends Subscription> underlying;
    private final Scheduler scheduler;
    private final long execTime;

    public SleepingAction(Func2<? super Scheduler, ? super T, ? extends Subscription> underlying, Scheduler scheduler, long execTime) {
        this.underlying = underlying;
        this.scheduler = scheduler;
        this.execTime = execTime;
    }

    @Override
    public Subscription call(Scheduler s, T state) {
        long delay;
        if (this.execTime > this.scheduler.now() && (delay = this.execTime - this.scheduler.now()) > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return this.underlying.call(s, state);
    }
}

