/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Scheduler;
import rx.Subscription;
import rx.util.functions.Func2;

public class TestScheduler
extends Scheduler {
    private final Queue<TimedAction<?>> queue = new PriorityQueue(11, new CompareActionsByTime());
    private long time;

    @Override
    public long now() {
        return TimeUnit.NANOSECONDS.toMillis(this.time);
    }

    public void advanceTimeBy(long delayTime, TimeUnit unit) {
        this.advanceTimeTo(this.time + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
    }

    public void advanceTimeTo(long delayTime, TimeUnit unit) {
        long targetTime = unit.toNanos(delayTime);
        this.triggerActions(targetTime);
    }

    public void triggerActions() {
        this.triggerActions(this.time);
    }

    private void triggerActions(long targetTimeInNanos) {
        TimedAction<?> current;
        while (!this.queue.isEmpty() && ((TimedAction)(current = this.queue.peek())).time <= targetTimeInNanos) {
            this.time = ((TimedAction)current).time;
            this.queue.remove();
            if (((TimedAction)current).isCancelled.get()) continue;
            ((TimedAction)current).action.call(((TimedAction)current).scheduler, ((TimedAction)current).state);
        }
        this.time = targetTimeInNanos;
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action) {
        return this.schedule(state, action, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Subscription schedule(T state, Func2<? super Scheduler, ? super T, ? extends Subscription> action, long delayTime, TimeUnit unit) {
        final TimedAction timedAction = new TimedAction(this, this.time + unit.toNanos(delayTime), action, state);
        this.queue.add(timedAction);
        return new Subscription(){

            @Override
            public void unsubscribe() {
                timedAction.cancel();
            }
        };
    }

    private static class CompareActionsByTime
    implements Comparator<TimedAction<?>> {
        private CompareActionsByTime() {
        }

        @Override
        public int compare(TimedAction<?> action1, TimedAction<?> action2) {
            return Long.valueOf(((TimedAction)action1).time).compareTo(((TimedAction)action2).time);
        }
    }

    private static class TimedAction<T> {
        private final long time;
        private final Func2<? super Scheduler, ? super T, ? extends Subscription> action;
        private final T state;
        private final TestScheduler scheduler;
        private final AtomicBoolean isCancelled = new AtomicBoolean(false);

        private TimedAction(TestScheduler scheduler, long time, Func2<? super Scheduler, ? super T, ? extends Subscription> action, T state) {
            this.time = time;
            this.action = action;
            this.state = state;
            this.scheduler = scheduler;
        }

        public void cancel() {
            this.isCancelled.set(true);
        }

        public String toString() {
            return String.format("TimedAction(time = %d, action = %s)", this.time, this.action.toString());
        }
    }
}

