/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;
import rx.util.functions.Action1;

public final class AsyncSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    final AtomicReference<Notification<T>> lastNotification;

    public static <T> AsyncSubject<T> create() {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final AtomicReference lastNotification = new AtomicReference(new Notification());
        Observable.OnSubscribeFunc onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                AsyncSubject.emitValueToObserver((Notification)lastNotification.get(), o);
            }
        });
        return new AsyncSubject(onSubscribe, subscriptionManager, lastNotification);
    }

    protected static <T> void emitValueToObserver(Notification<T> n, Observer<? super T> o) {
        n.accept(o);
        if (n.isOnNext()) {
            o.onCompleted();
        }
    }

    protected AsyncSubject(Observable.OnSubscribeFunc<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, AtomicReference<Notification<T>> lastNotification) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.lastNotification = lastNotification;
    }

    @Override
    public void onCompleted() {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                for (SubjectSubscriptionManager.SubjectObserver subjectObserver : observers) {
                    AsyncSubject.emitValueToObserver(AsyncSubject.this.lastNotification.get(), subjectObserver);
                }
            }
        });
    }

    @Override
    public void onError(final Throwable e) {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                AsyncSubject.this.lastNotification.set(new Notification(e));
                for (SubjectSubscriptionManager.SubjectObserver subjectObserver : observers) {
                    AsyncSubject.emitValueToObserver(AsyncSubject.this.lastNotification.get(), subjectObserver);
                }
            }
        });
    }

    @Override
    public void onNext(T v) {
        this.lastNotification.set(new Notification<T>(v));
    }
}

