/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;
import rx.util.functions.Action1;

public final class BehaviorSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    final AtomicReference<Notification<T>> lastNotification;

    public static <T> BehaviorSubject<T> createWithDefaultValue(T defaultValue) {
        return BehaviorSubject.create(defaultValue);
    }

    public static <T> BehaviorSubject<T> create(T defaultValue) {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final AtomicReference<Notification<T>> lastNotification = new AtomicReference<Notification<T>>(new Notification<T>(defaultValue));
        Observable.OnSubscribeFunc onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                Notification n = (Notification)lastNotification.get();
                if (n.isOnNext()) {
                    n.accept(o);
                }
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                ((Notification)lastNotification.get()).accept(o);
            }
        });
        return new BehaviorSubject(onSubscribe, subscriptionManager, lastNotification);
    }

    protected BehaviorSubject(Observable.OnSubscribeFunc<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, AtomicReference<Notification<T>> lastNotification) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.lastNotification = lastNotification;
    }

    @Override
    public void onCompleted() {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                BehaviorSubject.this.lastNotification.set(new Notification());
                for (SubjectSubscriptionManager.SubjectObserver o : observers) {
                    o.onCompleted();
                }
            }
        });
    }

    @Override
    public void onError(final Throwable e) {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                BehaviorSubject.this.lastNotification.set(new Notification(e));
                for (SubjectSubscriptionManager.SubjectObserver o : observers) {
                    o.onError(e);
                }
            }
        });
    }

    @Override
    public void onNext(T v) {
        if (this.lastNotification.get().isOnNext()) {
            this.lastNotification.set(new Notification<T>(v));
            for (SubjectSubscriptionManager.SubjectObserver<Object> o : this.subscriptionManager.rawSnapshot()) {
                o.onNext(v);
            }
        }
    }
}

