/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;
import rx.util.functions.Action1;

public final class PublishSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    final AtomicReference<Notification<T>> lastNotification;

    public static <T> PublishSubject<T> create() {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final AtomicReference<Notification<T>> lastNotification = new AtomicReference<Notification<T>>();
        Observable.OnSubscribeFunc onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                ((Notification)lastNotification.get()).accept(o);
            }
        });
        return new PublishSubject(onSubscribe, subscriptionManager, lastNotification);
    }

    protected PublishSubject(Observable.OnSubscribeFunc<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, AtomicReference<Notification<T>> lastNotification) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.lastNotification = lastNotification;
    }

    @Override
    public void onCompleted() {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                PublishSubject.this.lastNotification.set(new Notification());
                for (SubjectSubscriptionManager.SubjectObserver o : observers) {
                    o.onCompleted();
                }
            }
        });
    }

    @Override
    public void onError(final Throwable e) {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                PublishSubject.this.lastNotification.set(new Notification(e));
                for (SubjectSubscriptionManager.SubjectObserver o : observers) {
                    o.onError(e);
                }
            }
        });
    }

    @Override
    public void onNext(T v) {
        for (SubjectSubscriptionManager.SubjectObserver<Object> o : this.subscriptionManager.rawSnapshot()) {
            o.onNext(v);
        }
    }
}

