/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;
import rx.util.functions.Action1;

public final class ReplaySubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> subscriptionManager;
    private final ReplayState<T> state;

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int initialCapacity) {
        SubjectSubscriptionManager subscriptionManager = new SubjectSubscriptionManager();
        final ReplayState state = new ReplayState(initialCapacity);
        Observable.OnSubscribeFunc onSubscribe = subscriptionManager.getOnSubscribeFunc(new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                int lastIndex = ReplaySubject.replayObserverFromIndex(state.history, 0, o);
                state.replayState.put(o, lastIndex);
            }
        }, new Action1<SubjectSubscriptionManager.SubjectObserver<? super T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
                ReplaySubject.replayObserverFromIndex(state.history, state.replayState.get(o), o);
            }
        });
        return new ReplaySubject(onSubscribe, subscriptionManager, state);
    }

    protected ReplaySubject(Observable.OnSubscribeFunc<T> onSubscribe, SubjectSubscriptionManager<T> subscriptionManager, ReplayState<T> state) {
        super(onSubscribe);
        this.subscriptionManager = subscriptionManager;
        this.state = state;
    }

    @Override
    public void onCompleted() {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                ((ReplaySubject)ReplaySubject.this).state.history.complete(new Notification());
                for (SubjectSubscriptionManager.SubjectObserver o : observers) {
                    if (!ReplaySubject.this.caughtUp(o)) continue;
                    o.onCompleted();
                }
            }
        });
    }

    @Override
    public void onError(final Throwable e) {
        this.subscriptionManager.terminate(new Action1<Collection<SubjectSubscriptionManager.SubjectObserver<? super T>>>(){

            @Override
            public void call(Collection<SubjectSubscriptionManager.SubjectObserver<? super T>> observers) {
                ((ReplaySubject)ReplaySubject.this).state.history.complete(new Notification(e));
                for (SubjectSubscriptionManager.SubjectObserver o : observers) {
                    if (!ReplaySubject.this.caughtUp(o)) continue;
                    o.onError(e);
                }
            }
        });
    }

    @Override
    public void onNext(T v) {
        if (this.state.history.terminalValue.get() != null) {
            return;
        }
        this.state.history.next(v);
        for (SubjectSubscriptionManager.SubjectObserver<Object> o : this.subscriptionManager.rawSnapshot()) {
            if (!this.caughtUp(o)) continue;
            o.onNext(v);
        }
    }

    private boolean caughtUp(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
        if (!o.caughtUp) {
            o.caughtUp = true;
            this.replayObserver(o);
            return false;
        }
        return true;
    }

    private void replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
        Integer lastEmittedLink = this.state.replayState.get(observer);
        if (lastEmittedLink == null) {
            throw new IllegalStateException("failed to find lastEmittedLink for: " + observer);
        }
        int l = ReplaySubject.replayObserverFromIndex(this.state.history, lastEmittedLink, observer);
        this.state.replayState.put(observer, l);
    }

    private static <T> int replayObserverFromIndex(History<T> history, Integer l, SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
        while (l < ((History)history).index.get()) {
            observer.onNext(((History)history).list.get(l));
            Integer n = l;
            Integer n2 = l = Integer.valueOf(l + 1);
        }
        if (((History)history).terminalValue.get() != null) {
            ((Notification)((History)history).terminalValue.get()).accept(observer);
        }
        return l;
    }

    private static class History<T> {
        private final AtomicInteger index = new AtomicInteger(0);
        private final ArrayList<T> list;
        private final AtomicReference<Notification<T>> terminalValue;

        public History(int initialCapacity) {
            this.list = new ArrayList(initialCapacity);
            this.terminalValue = new AtomicReference();
        }

        public boolean next(T n) {
            if (this.terminalValue.get() == null) {
                this.list.add(n);
                this.index.getAndIncrement();
                return true;
            }
            return false;
        }

        public void complete(Notification<T> n) {
            this.terminalValue.set(n);
        }
    }

    private static class ReplayState<T> {
        final History<T> history;
        final ConcurrentHashMap<Observer<? super T>, Integer> replayState;

        public ReplayState(int initialCapacity) {
            this.history = new History(initialCapacity);
            this.replayState = new ConcurrentHashMap();
        }
    }
}

