/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action1;

class SubjectSubscriptionManager<T> {
    private AtomicReference<State<T>> state = new AtomicReference(new State());

    SubjectSubscriptionManager() {
    }

    public Observable.OnSubscribeFunc<T> getOnSubscribeFunc(final Action1<SubjectObserver<? super T>> onSubscribe, final Action1<SubjectObserver<? super T>> onTerminated) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> actualObserver) {
                Subscription s;
                State current;
                SubjectObserver observer = new SubjectObserver(actualObserver);
                if (onSubscribe != null) {
                    onSubscribe.call(observer);
                }
                State newState = null;
                boolean addedObserver = false;
                do {
                    current = (State)SubjectSubscriptionManager.this.state.get();
                    if (current.terminated) {
                        s = Subscriptions.empty();
                        addedObserver = false;
                        newState = current;
                        try {
                            current.terminationLatch.await();
                            break;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("Interrupted waiting for termination.", e);
                        }
                    }
                    final SafeObservableSubscription subscription = new SafeObservableSubscription();
                    s = subscription;
                    addedObserver = true;
                    subscription.wrap(new Subscription(){

                        @Override
                        public void unsubscribe() {
                            State newState;
                            State current;
                            do {
                                current = (State)SubjectSubscriptionManager.this.state.get();
                                newState = current.removeObserver(subscription);
                            } while (!SubjectSubscriptionManager.this.state.compareAndSet(current, newState));
                        }
                    });
                    newState = current.addObserver(subscription, observer);
                } while (!SubjectSubscriptionManager.this.state.compareAndSet(current, newState));
                if (newState.terminated && !addedObserver) {
                    onTerminated.call(observer);
                }
                return s;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(Action1<Collection<SubjectObserver<? super T>>> onTerminate) {
        State<T> current;
        State<T> newState = null;
        do {
            current = this.state.get();
            if (!current.terminated) continue;
            return;
        } while (!this.state.compareAndSet(current, newState = current.terminate()));
        try {
            onTerminate.call(Arrays.asList(newState.observers));
        }
        finally {
            newState.terminationLatch.countDown();
        }
    }

    public SubjectObserver<Object>[] rawSnapshot() {
        return this.state.get().observers;
    }

    protected static class SubjectObserver<T>
    implements Observer<T> {
        private final Observer<? super T> actual;
        protected volatile boolean caughtUp = false;

        SubjectObserver(Observer<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        @Override
        public void onNext(T v) {
            this.actual.onNext(v);
        }
    }

    protected static class State<T> {
        final boolean terminated;
        final CountDownLatch terminationLatch;
        final Subscription[] subscriptions;
        final SubjectObserver[] observers;
        final Subscription[] EMPTY_S = new Subscription[0];
        final SubjectObserver[] EMPTY_O = new SubjectObserver[0];

        private State(boolean isTerminated, CountDownLatch terminationLatch, Subscription[] subscriptions, SubjectObserver[] observers) {
            this.terminationLatch = terminationLatch;
            this.terminated = isTerminated;
            this.subscriptions = subscriptions;
            this.observers = observers;
        }

        State() {
            this.terminated = false;
            this.terminationLatch = null;
            this.subscriptions = this.EMPTY_S;
            this.observers = this.EMPTY_O;
        }

        public State<T> terminate() {
            if (this.terminated) {
                throw new IllegalStateException("Already terminated.");
            }
            return new State<T>(true, new CountDownLatch(1), this.subscriptions, this.observers);
        }

        public State<T> addObserver(Subscription s, SubjectObserver<? super T> observer) {
            int n = this.observers.length;
            Subscription[] newsubscriptions = Arrays.copyOf(this.subscriptions, n + 1);
            SubjectObserver[] newobservers = Arrays.copyOf(this.observers, n + 1);
            newsubscriptions[n] = s;
            newobservers[n] = observer;
            return this.createNewWith(newsubscriptions, newobservers);
        }

        private State<T> createNewWith(Subscription[] newsubscriptions, SubjectObserver[] newobservers) {
            return new State<T>(this.terminated, this.terminationLatch, newsubscriptions, newobservers);
        }

        public State<T> removeObserver(Subscription s) {
            if (this.observers.length == 0) {
                return this;
            }
            int n = Math.max(this.observers.length - 1, 1);
            int copied = 0;
            Subscription[] newsubscriptions = Arrays.copyOf(this.subscriptions, n);
            SubjectObserver[] newobservers = Arrays.copyOf(this.observers, n);
            for (int i = 0; i < this.subscriptions.length; ++i) {
                Subscription s0 = this.subscriptions[i];
                if (s0 == s) continue;
                if (copied == n) {
                    return this;
                }
                newsubscriptions[copied] = s0;
                newobservers[copied] = this.observers[i];
                ++copied;
            }
            if (copied == 0) {
                return this.createNewWith(this.EMPTY_S, this.EMPTY_O);
            }
            if (copied < n) {
                return this.createNewWith(Arrays.copyOf(newsubscriptions, copied), Arrays.copyOf(newobservers, copied));
            }
            return this.createNewWith(newsubscriptions, newobservers);
        }
    }
}

