/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.util.CompositeException;

public final class CompositeSubscription
implements Subscription {
    private final AtomicReference<State> state = new AtomicReference();

    public CompositeSubscription(Subscription ... subscriptions) {
        this.state.set(new State(false, Arrays.asList(subscriptions)));
    }

    public boolean isUnsubscribed() {
        return this.state.get().isUnsubscribed;
    }

    public void add(Subscription s) {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            s.unsubscribe();
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.add(s)));
    }

    public void remove(Subscription s) {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.remove(s)));
        s.unsubscribe();
    }

    public void clear() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.clear()));
        CompositeSubscription.unsubscribeFromAll(oldState.subscriptions);
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.unsubscribe()));
        CompositeSubscription.unsubscribeFromAll(oldState.subscriptions);
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        ArrayList<Throwable> es = new ArrayList<Throwable>();
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                es.add(e);
            }
        }
        if (!es.isEmpty()) {
            throw new CompositeException("Failed to unsubscribe to 1 or more subscriptions.", es);
        }
    }

    private static final class State {
        final boolean isUnsubscribed;
        final List<Subscription> subscriptions;

        State(boolean u, List<Subscription> s) {
            this.isUnsubscribed = u;
            this.subscriptions = s;
        }

        State unsubscribe() {
            return new State(true, this.subscriptions);
        }

        State add(Subscription s) {
            ArrayList<Subscription> newSubscriptions = new ArrayList<Subscription>();
            newSubscriptions.addAll(this.subscriptions);
            newSubscriptions.add(s);
            return new State(this.isUnsubscribed, newSubscriptions);
        }

        State remove(Subscription s) {
            ArrayList<Subscription> newSubscriptions = new ArrayList<Subscription>();
            newSubscriptions.addAll(this.subscriptions);
            newSubscriptions.remove(s);
            return new State(this.isUnsubscribed, newSubscriptions);
        }

        State clear() {
            return new State(this.isUnsubscribed, new ArrayList<Subscription>());
        }
    }
}

