/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicReference;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class SerialSubscription
implements Subscription {
    private final AtomicReference<State> state = new AtomicReference<State>(new State(false, Subscriptions.empty()));

    public boolean isUnsubscribed() {
        return this.state.get().isUnsubscribed;
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.unsubscribe()));
        oldState.subscription.unsubscribe();
    }

    @Deprecated
    public void setSubscription(Subscription s) {
        this.set(s);
    }

    public void set(Subscription s) {
        State newState;
        State oldState;
        if (s == null) {
            throw new IllegalArgumentException("Subscription can not be null");
        }
        do {
            oldState = this.state.get();
            if (!oldState.isUnsubscribed) continue;
            s.unsubscribe();
            return;
        } while (!this.state.compareAndSet(oldState, newState = oldState.set(s)));
        oldState.subscription.unsubscribe();
    }

    @Deprecated
    public Subscription getSubscription() {
        return this.get();
    }

    public Subscription get() {
        return this.state.get().subscription;
    }

    private static final class State {
        final boolean isUnsubscribed;
        final Subscription subscription;

        State(boolean u, Subscription s) {
            this.isUnsubscribed = u;
            this.subscription = s;
        }

        State unsubscribe() {
            return new State(true, this.subscription);
        }

        State set(Subscription s) {
            return new State(this.isUnsubscribed, s);
        }
    }
}

