/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.core;

import com.soulgalore.crawler.util.HeaderUtil;
import java.util.Collections;
import java.util.Map;

public final class CrawlerConfiguration {
    public static final String MAX_THREADS_PROPERTY_NAME = "com.soulgalore.crawler.nrofhttpthreads";
    public static final String SOCKET_TIMEOUT_PROPERTY_NAME = "com.soulgalore.crawler.http.socket.timeout";
    public static final String CONNECTION_TIMEOUT_PROPERTY_NAME = "com.soulgalore.crawler.http.connection.timeout";
    public static final String AUTH_PROPERTY_NAME = "com.soulgalore.crawler.auth";
    public static final String PROXY_PROPERTY_NAME = "com.soulgalore.crawler.proxy";
    public static final int DEFAULT_CRAWL_LEVEL = 1;
    public static final boolean DEFAULT_SHOULD_VERIFY_URLS = true;
    private int maxLevels = 1;
    private String notOnPath = "";
    private String onlyOnPath = "";
    private String requestHeaders = "";
    private String startUrl;
    private Map<String, String> requestHeadersMap = Collections.emptyMap();
    private boolean verifyUrls = true;

    private CrawlerConfiguration() {
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public Map<String, String> getRequestHeadersMap() {
        return this.requestHeadersMap;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public String getNotOnPath() {
        return this.notOnPath;
    }

    public String getOnlyOnPath() {
        return this.onlyOnPath;
    }

    public String getStartUrl() {
        return this.startUrl;
    }

    public boolean isVerifyUrls() {
        return this.verifyUrls;
    }

    private CrawlerConfiguration copy() {
        CrawlerConfiguration conf = new CrawlerConfiguration();
        conf.setMaxLevels(this.getMaxLevels());
        conf.setNotOnPath(this.getNotOnPath());
        conf.setOnlyOnPath(this.getOnlyOnPath());
        conf.setStartUrl(this.getStartUrl());
        conf.setVerifyUrls(this.isVerifyUrls());
        conf.setRequestHeaders(this.getRequestHeaders());
        return conf;
    }

    private void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
        this.requestHeadersMap = HeaderUtil.getInstance().createHeadersFromString(requestHeaders);
    }

    private void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    private void setNotOnPath(String notOnPath) {
        this.notOnPath = notOnPath;
    }

    private void setOnlyOnPath(String onlyOnPath) {
        this.onlyOnPath = onlyOnPath;
    }

    private void setStartUrl(String startUrl) {
        this.startUrl = startUrl;
    }

    private void setVerifyUrls(boolean verifyUrls) {
        this.verifyUrls = verifyUrls;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxLevels;
        result = 31 * result + (this.notOnPath == null ? 0 : this.notOnPath.hashCode());
        result = 31 * result + (this.onlyOnPath == null ? 0 : this.onlyOnPath.hashCode());
        result = 31 * result + (this.startUrl == null ? 0 : this.startUrl.hashCode());
        result = 31 * result + (this.verifyUrls ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrawlerConfiguration other = (CrawlerConfiguration)obj;
        if (this.maxLevels != other.maxLevels) {
            return false;
        }
        if (this.notOnPath == null ? other.notOnPath != null : !this.notOnPath.equals(other.notOnPath)) {
            return false;
        }
        if (this.onlyOnPath == null ? other.onlyOnPath != null : !this.onlyOnPath.equals(other.onlyOnPath)) {
            return false;
        }
        if (this.startUrl == null ? other.startUrl != null : !this.startUrl.equals(other.startUrl)) {
            return false;
        }
        return this.verifyUrls == other.verifyUrls;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final CrawlerConfiguration configuration = new CrawlerConfiguration();

        public CrawlerConfiguration build() {
            return this.configuration.copy();
        }

        public Builder setMaxLevels(int maxLevels) {
            this.configuration.setMaxLevels(maxLevels);
            return this;
        }

        public Builder setNotOnPath(String notOnPath) {
            this.configuration.setNotOnPath(notOnPath);
            return this;
        }

        public Builder setOnlyOnPath(String onlyOnPath) {
            this.configuration.setOnlyOnPath(onlyOnPath);
            return this;
        }

        public Builder setStartUrl(String startUrl) {
            this.configuration.setStartUrl(startUrl);
            return this;
        }

        public Builder setVerifyUrls(boolean verifyUrls) {
            this.configuration.setVerifyUrls(verifyUrls);
            return this;
        }

        public Builder setRequestHeaders(String requestHeaders) {
            this.configuration.setRequestHeaders(requestHeaders);
            return this;
        }
    }
}

