/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.core;

import com.soulgalore.crawler.core.PageURL;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class HTMLPageResponse {
    private static final int NO_HTTP_PORT = -1;
    private final Document doc;
    private final String encoding;
    private final PageURL url;
    private final int responseCode;
    private final String responseType;
    private final Map<String, String> headers;
    private final long fetchTime;

    public HTMLPageResponse(PageURL pageUrl, int theResponseCode, Map<String, String> theHeaders, String theBody, String theEncoding, long theSize, String theResponseType, long theFetchTime) {
        this.encoding = theEncoding;
        this.url = pageUrl;
        this.responseCode = theResponseCode;
        this.responseType = theResponseType;
        this.headers = theHeaders;
        this.fetchTime = theFetchTime;
        if (!pageUrl.isWrongSyntax()) {
            String baseUri = pageUrl.getUri().getScheme() + "://" + pageUrl.getUri().getHost() + (pageUrl.getUri().getPort() != -1 ? ":" + pageUrl.getUri().getPort() : "") + (pageUrl.getUri().getPath().contains(".") ? pageUrl.getUri().getPath() : pageUrl.getUri().getPath() + (pageUrl.getUri().getPath().endsWith("/") ? "" : "/"));
            this.doc = Jsoup.parse((String)theBody, (String)baseUri);
        } else {
            this.doc = null;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Document getBody() {
        return this.doc;
    }

    public String getUrl() {
        return this.url.getUrl();
    }

    public String getResponseType() {
        return this.responseType;
    }

    public PageURL getPageUrl() {
        return this.url;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.headers;
    }

    public String getHeaderValue(String key) {
        return this.headers.get(key);
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "url:" + this.getUrl() + "responseCode:" + this.getResponseCode() + "encoding:" + this.encoding + " type:" + this.responseType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.responseCode;
        result = 31 * result + (this.responseType == null ? 0 : this.responseType.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HTMLPageResponse other = (HTMLPageResponse)obj;
        if (this.responseCode != other.responseCode) {
            return false;
        }
        if (this.responseType == null ? other.responseType != null : !this.responseType.equals(other.responseType)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

