/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.core;

import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;

public class PageURL {
    private final String url;
    private final URI uri;
    private final String host;
    private final String referer;
    private final boolean isWrongSyntax;

    public PageURL(String theUrl) {
        this(theUrl, "");
    }

    public PageURL(String theUrl, String theUrlReferer) {
        this.url = theUrl;
        this.referer = theUrlReferer;
        URI tmpURI = null;
        try {
            URL u = null;
            u = this.url.contains("%") ? new URL(URLDecoder.decode(theUrl, "UTF-8")) : new URL(theUrl);
            tmpURI = new URI(u.getProtocol(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), u.getQuery(), null);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.uri = tmpURI;
        this.isWrongSyntax = this.uri == null;
        this.host = this.uri == null ? null : this.uri.getHost();
    }

    public boolean isWrongSyntax() {
        return this.isWrongSyntax;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " url:" + this.url;
    }

    public int hashCode() {
        if (this.uri == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        String hash = this.uri.toString();
        if (hash.endsWith("/")) {
            hash = hash.substring(0, hash.length() - 1);
        }
        result = 31 * result + hash.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageURL other = (PageURL)obj;
        if (this.uri == null) {
            if (other.uri != null) {
                return false;
            }
        } else {
            String withoutEndingSlash;
            if (this.uri.equals(other.uri)) {
                return true;
            }
            if (this.uri.toString().endsWith("/") && (withoutEndingSlash = this.uri.toString().substring(0, this.uri.toString().length() - 1)).equals(other.uri.toString())) {
                return true;
            }
        }
        return false;
    }
}

