/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.core.assets.impl;

import com.google.inject.Inject;
import com.soulgalore.crawler.core.CrawlerConfiguration;
import com.soulgalore.crawler.core.HTMLPageResponse;
import com.soulgalore.crawler.core.assets.AssetFetcher;
import com.soulgalore.crawler.core.assets.AssetResponse;
import com.soulgalore.crawler.core.assets.AssetResponseCallable;
import com.soulgalore.crawler.core.assets.AssetsParser;
import com.soulgalore.crawler.core.assets.AssetsVerificationResult;
import com.soulgalore.crawler.core.assets.AssetsVerifier;
import com.soulgalore.crawler.util.StatusCode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jsoup.nodes.Document;

public class DefaultAssetsVerifier
implements AssetsVerifier {
    private final ExecutorService service;
    private final AssetFetcher responseCodeGetter;
    private final AssetsParser parser;

    @Inject
    public DefaultAssetsVerifier(ExecutorService theService, AssetFetcher getter, AssetsParser theParser) {
        this.service = theService;
        this.responseCodeGetter = getter;
        this.parser = theParser;
    }

    @Override
    public AssetsVerificationResult verify(Set<HTMLPageResponse> responses, CrawlerConfiguration configuration) {
        Map<String, String> requestHeaders = configuration.getRequestHeadersMap();
        HashSet urls = new HashSet();
        HashSet<Future<Set<String>>> fut = new HashSet<Future<Set<String>>>();
        for (HTMLPageResponse hTMLPageResponse : responses) {
            fut.add(this.service.submit(new AssetsParserCallable(hTMLPageResponse.getBody(), this.parser)));
        }
        for (Future future : fut) {
            try {
                urls.addAll((Collection)future.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        HashSet<AssetResponse> working = new HashSet<AssetResponse>();
        HashSet<AssetResponse> hashSet = new HashSet<AssetResponse>();
        HashMap<Future<AssetResponse>, String> futures = new HashMap<Future<AssetResponse>, String>(urls.size());
        for (String url : urls) {
            futures.put(this.service.submit(new AssetResponseCallable(url, this.responseCodeGetter, requestHeaders)), url);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                AssetResponse assetResponse = (AssetResponse)((Future)entry.getKey()).get();
                if (StatusCode.isResponseCodeOk(assetResponse.getResponseCode())) {
                    working.add(assetResponse);
                    continue;
                }
                hashSet.add(assetResponse);
            }
            catch (InterruptedException e) {
                hashSet.add(new AssetResponse((String)entry.getValue(), StatusCode.SC_SERVER_RESPONSE_UNKNOWN.getCode(), -1L));
            }
            catch (ExecutionException e) {
                hashSet.add(new AssetResponse((String)entry.getValue(), StatusCode.SC_SERVER_RESPONSE_UNKNOWN.getCode(), -1L));
            }
        }
        return new AssetsVerificationResult(working, hashSet);
    }

    @Override
    public void shutdown() {
        this.service.shutdown();
    }

    private static class AssetsParserCallable
    implements Callable<Set<String>> {
        private final Document doc;
        private final AssetsParser parser;

        private AssetsParserCallable(Document theDoc, AssetsParser theParsers) {
            this.doc = theDoc;
            this.parser = theParsers;
        }

        @Override
        public Set<String> call() throws Exception {
            return this.parser.getAssets(this.doc);
        }
    }
}

