/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.core.assets.impl;

import com.google.inject.Inject;
import com.soulgalore.crawler.core.assets.AssetFetcher;
import com.soulgalore.crawler.core.assets.AssetResponse;
import com.soulgalore.crawler.util.StatusCode;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.util.EntityUtils;

public class HTTPClientAssetFetcher
implements AssetFetcher {
    private final HttpClient httpClient;

    @Inject
    public HTTPClientAssetFetcher(HttpClient client) {
        this.httpClient = client;
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssetResponse getAsset(String url, Map<String, String> requestHeaders) {
        HttpGet get = new HttpGet(url);
        for (String key : requestHeaders.keySet()) {
            get.setHeader(key, requestHeaders.get(key));
        }
        HttpEntity entity = null;
        long start = System.currentTimeMillis();
        try {
            HttpResponse resp = this.httpClient.execute((HttpUriRequest)get);
            long time = System.currentTimeMillis() - start;
            int sc = resp.getStatusLine().getStatusCode();
            entity = resp.getEntity();
            EntityUtils.consume((HttpEntity)entity);
            AssetResponse assetResponse = new AssetResponse(url, sc, time);
            return assetResponse;
        }
        catch (ConnectTimeoutException e) {
            AssetResponse assetResponse = new AssetResponse(url, StatusCode.SC_SERVER_RESPONSE_TIMEOUT.getCode(), System.currentTimeMillis() - start);
            return assetResponse;
        }
        catch (SocketTimeoutException e) {
            AssetResponse assetResponse = new AssetResponse(url, StatusCode.SC_SERVER_RESPONSE_TIMEOUT.getCode(), System.currentTimeMillis() - start);
            return assetResponse;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            AssetResponse assetResponse = new AssetResponse(url, StatusCode.SC_SERVER_RESPONSE_UNKNOWN.getCode(), -1L);
            return assetResponse;
        }
        catch (IOException e) {
            e.printStackTrace();
            AssetResponse assetResponse = new AssetResponse(url, StatusCode.SC_SERVER_RESPONSE_UNKNOWN.getCode(), -1L);
            return assetResponse;
        }
        finally {
            get.releaseConnection();
        }
    }
}

