/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.core.impl;

import com.google.inject.Inject;
import com.soulgalore.crawler.core.HTMLPageResponse;
import com.soulgalore.crawler.core.HTMLPageResponseFetcher;
import com.soulgalore.crawler.core.PageURL;
import com.soulgalore.crawler.util.StatusCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HTTPClientResponseFetcher
implements HTMLPageResponseFetcher {
    private final HttpClient httpClient;

    @Inject
    public HTTPClientResponseFetcher(HttpClient client) {
        this.httpClient = client;
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLPageResponse get(PageURL url, boolean getPage, Map<String, String> requestHeaders, boolean followRedirectsToNewDomain) {
        HTMLPageResponse hTMLPageResponse;
        if (url.isWrongSyntax()) {
            return new HTMLPageResponse(url, StatusCode.SC_MALFORMED_URI.getCode(), Collections.<String, String>emptyMap(), "", "", 0L, "", 0L);
        }
        HttpGet get = new HttpGet(url.getUri());
        for (String key : requestHeaders.keySet()) {
            get.setHeader(key, requestHeaders.get(key));
        }
        HttpEntity entity = null;
        long start = System.currentTimeMillis();
        try {
            String encoding;
            BasicHttpContext localContext = new BasicHttpContext();
            HttpResponse resp = this.httpClient.execute((HttpUriRequest)get, (HttpContext)localContext);
            long fetchTime = System.currentTimeMillis() - start;
            HttpHost target = (HttpHost)localContext.getAttribute("http.target_host");
            HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
            String newURL = req.getURI().toString().startsWith("http") ? req.getURI().toString() : target + req.getURI().toString();
            entity = resp.getEntity();
            Map<String, String> headersAndValues = getPage || !StatusCode.isResponseCodeOk(resp.getStatusLine().getStatusCode()) ? this.getHeaders(resp) : Collections.emptyMap();
            String string = encoding = entity.getContentEncoding() != null ? entity.getContentEncoding().getValue() : "";
            String body = getPage ? this.getBody(entity, "".equals(encoding) ? "UTF-8" : encoding) : "";
            long size = entity.getContentLength();
            String type = entity.getContentType() != null ? entity.getContentType().getValue() : "";
            int sc = resp.getStatusLine().getStatusCode();
            EntityUtils.consume((HttpEntity)entity);
            if (!followRedirectsToNewDomain && !newURL.contains(url.getHost())) {
                HTMLPageResponse hTMLPageResponse2 = new HTMLPageResponse(url, StatusCode.SC_SERVER_REDIRECT_TO_NEW_DOMAIN.getCode(), Collections.<String, String>emptyMap(), "", "", 0L, "", fetchTime);
                return hTMLPageResponse2;
            }
            HTMLPageResponse hTMLPageResponse3 = new HTMLPageResponse(url.getUrl() != newURL ? new PageURL(newURL, url.getReferer()) : url, sc, headersAndValues, body, encoding, size, type, fetchTime);
            return hTMLPageResponse3;
        }
        catch (SocketTimeoutException e) {
            System.err.println(e);
            hTMLPageResponse = new HTMLPageResponse(url, StatusCode.SC_SERVER_RESPONSE_TIMEOUT.getCode(), Collections.<String, String>emptyMap(), "", "", 0L, "", System.currentTimeMillis() - start);
            return hTMLPageResponse;
        }
        catch (ConnectTimeoutException e) {
            System.err.println((Object)e);
            hTMLPageResponse = new HTMLPageResponse(url, StatusCode.SC_SERVER_RESPONSE_TIMEOUT.getCode(), Collections.<String, String>emptyMap(), "", "", 0L, "", System.currentTimeMillis() - start);
            return hTMLPageResponse;
        }
        catch (IOException e) {
            System.err.println(e);
            hTMLPageResponse = new HTMLPageResponse(url, StatusCode.SC_SERVER_RESPONSE_UNKNOWN.getCode(), Collections.<String, String>emptyMap(), "", "", 0L, "", -1L);
            return hTMLPageResponse;
        }
        finally {
            get.releaseConnection();
        }
    }

    protected String getBody(HttpEntity entity, String enc) throws IOException {
        StringBuilder body = new StringBuilder();
        String buffer = "";
        if (entity != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), enc));
            while ((buffer = reader.readLine()) != null) {
                body.append(buffer);
            }
            reader.close();
        }
        return body.toString();
    }

    protected Map<String, String> getHeaders(HttpResponse resp) {
        Header[] httpHeaders;
        HashMap<String, String> headersAndValues = new HashMap<String, String>();
        for (Header header : httpHeaders = resp.getAllHeaders()) {
            headersAndValues.put(header.getName(), header.getValue());
        }
        return headersAndValues;
    }
}

