/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.soulgalore.crawler.util.Auth;
import com.soulgalore.crawler.util.AuthUtil;
import com.soulgalore.crawler.util.HTTPSFaker;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.cookie.BestMatchSpec;
import org.apache.http.params.HttpParams;

public class HttpClientProvider
implements Provider<HttpClient> {
    private final int nrOfThreads;
    private final int maxToRoute;
    private final int socketTimeout;
    private final int connectionTimeout;
    private final Set<Auth> auths;
    private final String proxy;

    @Inject
    public HttpClientProvider(@Named(value="com.soulgalore.crawler.nrofhttpthreads") int maxNrOfThreads, @Named(value="com.soulgalore.crawler.http.socket.timeout") int theSocketTimeout, @Named(value="com.soulgalore.crawler.http.connection.timeout") int theConnectionTimeout, @Named(value="com.soulgalore.crawler.auth") String authAsString, @Named(value="com.soulgalore.crawler.proxy") String theProxy) {
        this.nrOfThreads = maxNrOfThreads;
        this.maxToRoute = maxNrOfThreads;
        this.connectionTimeout = theConnectionTimeout;
        this.socketTimeout = theSocketTimeout;
        this.auths = AuthUtil.getInstance().createAuthsFromString(authAsString);
        this.proxy = theProxy;
    }

    public HttpClient get() {
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager();
        cm.setMaxTotal(this.nrOfThreads);
        cm.setDefaultMaxPerRoute(this.maxToRoute);
        DefaultHttpClient client = HTTPSFaker.getClientThatAllowAnyHTTPS(cm);
        client.getParams().setParameter("http.socket.timeout", (Object)this.socketTimeout);
        client.getParams().setParameter("http.connection.timeout", (Object)this.connectionTimeout);
        client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
        client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
        CookieSpecFactory csf = new CookieSpecFactory(){

            public CookieSpec newInstance(HttpParams params) {
                return new BestMatchSpecWithURLErrorLog();
            }
        };
        client.getCookieSpecs().register("bestmatchwithurl", csf);
        client.getParams().setParameter("http.protocol.cookie-policy", (Object)"bestmatchwithurl");
        if (!"".equals(this.proxy)) {
            StringTokenizer token = new StringTokenizer(this.proxy, ":");
            if (token.countTokens() == 3) {
                String proxyProtocol = token.nextToken();
                String proxyHost = token.nextToken();
                int proxyPort = Integer.parseInt(token.nextToken());
                HttpHost proxy = new HttpHost(proxyHost, proxyPort, proxyProtocol);
                client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            } else {
                System.err.println("Invalid proxy configuration: " + this.proxy);
            }
        }
        if (this.auths.size() > 0) {
            for (Auth authObject : this.auths) {
                client.getCredentialsProvider().setCredentials(new AuthScope(authObject.getScope(), authObject.getPort()), (Credentials)new UsernamePasswordCredentials(authObject.getUserName(), authObject.getPassword()));
            }
        }
        return client;
    }

    private class BestMatchSpecWithURLErrorLog
    extends BestMatchSpec {
        private BestMatchSpecWithURLErrorLog() {
        }

        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            try {
                super.validate(cookie, origin);
            }
            catch (MalformedCookieException e) {
                System.err.println("Cookie rejected for url: " + origin.getHost() + (origin.getPort() != 80 ? ":" + origin.getPort() : "") + origin.getPath() + " the error:" + e.getMessage() + " for cookie:" + cookie.toString());
                throw e;
            }
        }
    }
}

