/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.run;

import com.soulgalore.crawler.core.CrawlerConfiguration;
import com.soulgalore.crawler.run.AbstractRunner;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractCrawl
extends AbstractRunner {
    private static final String URL = "url";
    private static final String LEVEL = "level";
    private static final String FOLLOW_PATH = "followPath";
    private static final String NO_FOLLOW_PATH = "notFollowPath";
    private static final String VERIFY = "verify";
    private static final String REQUEST_HEADERS = "requestHeaders";
    private final CrawlerConfiguration configuration = CrawlerConfiguration.builder().setMaxLevels(Integer.parseInt(this.getLine().getOptionValue("level", Integer.toString(1)))).setVerifyUrls(Boolean.parseBoolean(this.getLine().getOptionValue("verify", Boolean.toString(true)))).setOnlyOnPath(this.getLine().getOptionValue("followPath", "")).setNotOnPath(this.getLine().getOptionValue("notFollowPath", "")).setRequestHeaders(this.getLine().getOptionValue("requestHeaders", "")).setStartUrl(this.getLine().getOptionValue("url")).build();

    public AbstractCrawl(String[] args) throws ParseException {
        super(args);
    }

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        Option urlOption = new Option("u", "the page that is the startpoint of the crawl, examle http://mydomain.com/mypage");
        urlOption.setLongOpt(URL);
        urlOption.setArgName("URL");
        urlOption.setRequired(true);
        urlOption.setArgs(1);
        options.addOption(urlOption);
        Option levelOption = new Option("l", "how deep the crawl should be done, default is 1 [optional]");
        levelOption.setArgName("LEVEL");
        levelOption.setLongOpt(LEVEL);
        levelOption.setRequired(false);
        levelOption.setArgs(1);
        options.addOption(levelOption);
        Option followOption = new Option("p", "stay on this path when crawling [optional]");
        followOption.setArgName("PATH");
        followOption.setLongOpt(FOLLOW_PATH);
        followOption.setRequired(false);
        followOption.setArgs(1);
        options.addOption(followOption);
        Option noFollowOption = new Option("np", "no url:s on this path will be crawled [optional]");
        noFollowOption.setArgName("NOPATH");
        noFollowOption.setLongOpt(NO_FOLLOW_PATH);
        noFollowOption.setRequired(false);
        noFollowOption.setArgs(1);
        options.addOption(noFollowOption);
        Option verifyOption = new Option("v", "verify that all links are returning 200, default is set to true [optional]");
        verifyOption.setArgName("VERIFY");
        verifyOption.setLongOpt(VERIFY);
        verifyOption.setRequired(false);
        verifyOption.setArgs(1);
        options.addOption(verifyOption);
        Option requestHeadersOption = new Option("rh", "the request headers by the form of header1:value1@header2:value2 [optional]");
        requestHeadersOption.setArgName("REQUEST-HEADERS");
        requestHeadersOption.setLongOpt(REQUEST_HEADERS);
        requestHeadersOption.setRequired(false);
        requestHeadersOption.setArgs(1);
        options.addOption(requestHeadersOption);
        return options;
    }

    protected CrawlerConfiguration getConfiguration() {
        return this.configuration;
    }
}

