/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.run;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.soulgalore.crawler.core.Crawler;
import com.soulgalore.crawler.core.CrawlerResult;
import com.soulgalore.crawler.core.assets.AssetResponse;
import com.soulgalore.crawler.core.assets.AssetsVerificationResult;
import com.soulgalore.crawler.core.assets.AssetsVerifier;
import com.soulgalore.crawler.guice.CrawlModule;
import com.soulgalore.crawler.run.AbstractCrawl;
import com.soulgalore.crawler.util.StatusCode;
import org.apache.commons.cli.ParseException;

public class CrawlAndVerifyAssets
extends AbstractCrawl {
    CrawlAndVerifyAssets(String[] args) throws ParseException {
        super(args);
    }

    public static void main(String[] args) {
        try {
            CrawlAndVerifyAssets crawl = new CrawlAndVerifyAssets(args);
            crawl.crawl();
        }
        catch (ParseException e) {
            System.out.print(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void crawl() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CrawlModule()});
        Crawler crawler = (Crawler)injector.getInstance(Crawler.class);
        System.out.println("Start crawling ...");
        CrawlerResult result = crawler.getUrls(this.getConfiguration());
        System.out.println("Crawled  " + result.getVerifiedURLResponses().size() + " pages");
        System.out.println("Start verifyig assets ...");
        AssetsVerifier verifier = (AssetsVerifier)injector.getInstance(AssetsVerifier.class);
        AssetsVerificationResult assetsResult = verifier.verify(result.getVerifiedURLResponses(), this.getConfiguration());
        System.out.println(assetsResult.getWorkingAssets().size() + " assets is ok, " + assetsResult.getNonWorkingAssets().size() + " is not");
        for (AssetResponse resp : assetsResult.getNonWorkingAssets()) {
            System.out.println(resp.getUrl() + " code:" + StatusCode.toFriendlyName(resp.getResponseCode()));
        }
        crawler.shutdown();
        verifier.shutdown();
    }
}

