/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.run;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.soulgalore.crawler.core.Crawler;
import com.soulgalore.crawler.core.CrawlerResult;
import com.soulgalore.crawler.core.HTMLPageResponse;
import com.soulgalore.crawler.core.PageURL;
import com.soulgalore.crawler.guice.CrawlModule;
import com.soulgalore.crawler.run.AbstractCrawl;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CrawlToCsv
extends AbstractCrawl {
    public static final String DEFAULT_FILENAME = "result.csv";
    private final String fileName = this.getLine().getOptionValue("filename", "result.csv");

    CrawlToCsv(String[] args) throws ParseException {
        super(args);
    }

    public static void main(String[] args) {
        try {
            CrawlToCsv crawl = new CrawlToCsv(args);
            crawl.crawl();
        }
        catch (ParseException e) {
            System.out.print(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crawl() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CrawlModule()});
        Crawler crawler = (Crawler)injector.getInstance(Crawler.class);
        CrawlerResult result = crawler.getUrls(this.getConfiguration());
        StringBuilder builder = new StringBuilder();
        builder.append("URL,parent\n");
        for (PageURL workingUrl : result.getUrls()) {
            builder.append(workingUrl.getUrl()).append(",").append(workingUrl.getReferer()).append("\n");
        }
        if (result.getNonWorkingUrls().size() > 0) {
            builder.append("URL non working,parent\n");
        }
        for (HTMLPageResponse nonWorkingUrl : result.getNonWorkingUrls()) {
            builder.append(nonWorkingUrl.getUrl()).append(",").append(nonWorkingUrl.getPageUrl().getReferer()).append("\n");
        }
        System.out.println("Start storing file " + this.fileName);
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), "UTF-8"));
            out.write(builder.toString());
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
        crawler.shutdown();
    }

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        Option filenameOption = new Option("f", "the name of the csv output file, default name is result.csv [optional]");
        filenameOption.setArgName("FILENAME");
        filenameOption.setLongOpt("filename");
        filenameOption.setRequired(false);
        filenameOption.setArgs(1);
        options.addOption(filenameOption);
        return options;
    }
}

