/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.run;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.soulgalore.crawler.core.Crawler;
import com.soulgalore.crawler.core.CrawlerResult;
import com.soulgalore.crawler.core.HTMLPageResponse;
import com.soulgalore.crawler.core.PageURL;
import com.soulgalore.crawler.guice.CrawlModule;
import com.soulgalore.crawler.run.AbstractCrawl;
import com.soulgalore.crawler.util.StatusCode;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CrawlToFile
extends AbstractCrawl {
    public static final String DEFAULT_FILENAME = "urls.txt";
    public static final String DEFAULT_ERROR_FILENAME = "errorurls.txt";
    private final String fileName = this.getLine().getOptionValue("filename", "urls.txt");
    private final String errorFileName = this.getLine().getOptionValue("errorfilename", "errorurls.txt");
    private final boolean verbose = Boolean.valueOf(this.getLine().getOptionValue("verbose", "false"));

    CrawlToFile(String[] args) throws ParseException {
        super(args);
    }

    public static void main(String[] args) {
        try {
            CrawlToFile crawl = new CrawlToFile(args);
            crawl.crawl();
        }
        catch (ParseException e) {
            System.out.print(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void crawl() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CrawlModule()});
        Crawler crawler = (Crawler)injector.getInstance(Crawler.class);
        CrawlerResult result = crawler.getUrls(this.getConfiguration());
        StringBuilder workingUrls = new StringBuilder();
        StringBuilder nonWorkingUrls = new StringBuilder();
        for (PageURL workingUrl : result.getUrls()) {
            workingUrls.append(workingUrl.getUrl()).append("\n");
        }
        if (this.verbose) {
            System.out.println("Start storing file working urls " + this.fileName);
        }
        this.writeFile(this.fileName, workingUrls.toString());
        if (result.getNonWorkingUrls().size() > 0) {
            for (HTMLPageResponse nonWorkingUrl : result.getNonWorkingUrls()) {
                nonWorkingUrls.append(StatusCode.toFriendlyName(nonWorkingUrl.getResponseCode())).append(",").append(nonWorkingUrl.getUrl()).append("\n");
            }
            if (this.verbose) {
                System.out.println("Start storing file non working urls " + this.errorFileName);
            }
            this.writeFile(this.errorFileName, nonWorkingUrls.toString());
        }
        crawler.shutdown();
    }

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        Option filenameOption = new Option("f", "the name of the output file, default name is urls.txt [optional]");
        filenameOption.setArgName("FILENAME");
        filenameOption.setLongOpt("filename");
        filenameOption.setRequired(false);
        filenameOption.setArgs(1);
        options.addOption(filenameOption);
        Option errorFilenameOption = new Option("ef", "the name of the error output file, default name is errorurls.txt [optional]");
        errorFilenameOption.setArgName("ERRORFILENAME");
        errorFilenameOption.setLongOpt("errorfilename");
        errorFilenameOption.setRequired(false);
        errorFilenameOption.setArgs(1);
        options.addOption(errorFilenameOption);
        Option verboseOption = new Option("ve", "verbose logging, default is false [optional]");
        verboseOption.setArgName("VERBOSE");
        verboseOption.setLongOpt("verbose");
        verboseOption.setRequired(false);
        verboseOption.setArgs(1);
        verboseOption.setType(Boolean.class);
        options.addOption(verboseOption);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName, String output) {
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
            out.write(output);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
    }
}

