/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.run;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.soulgalore.crawler.core.Crawler;
import com.soulgalore.crawler.core.CrawlerResult;
import com.soulgalore.crawler.core.HTMLPageResponse;
import com.soulgalore.crawler.guice.CrawlModule;
import com.soulgalore.crawler.run.AbstractCrawl;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CrawlToPlainTxtOnlyMatching
extends AbstractCrawl {
    private final String keyword = this.getLine().getOptionValue("keyword");

    CrawlToPlainTxtOnlyMatching(String[] args) throws ParseException {
        super(args);
    }

    public static void main(String[] args) {
        try {
            CrawlToPlainTxtOnlyMatching crawl = new CrawlToPlainTxtOnlyMatching(args);
            crawl.crawl();
        }
        catch (ParseException e) {
            System.out.print(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void crawl() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CrawlModule()});
        Crawler crawler = (Crawler)injector.getInstance(Crawler.class);
        CrawlerResult result = crawler.getUrls(this.getConfiguration());
        for (HTMLPageResponse response : result.getVerifiedURLResponses()) {
            if (!response.getBody().toString().contains(this.keyword)) continue;
            System.out.println(response.getUrl());
        }
        crawler.shutdown();
    }

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        Option filenameOption = new Option("k", "the keyword to search for in the page  [required]");
        filenameOption.setArgName("KEYWORD");
        filenameOption.setLongOpt("keyword");
        filenameOption.setRequired(true);
        filenameOption.setArgs(1);
        options.addOption(filenameOption);
        return options;
    }
}

