/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.run;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.soulgalore.crawler.core.Crawler;
import com.soulgalore.crawler.core.CrawlerResult;
import com.soulgalore.crawler.core.PageURL;
import com.soulgalore.crawler.guice.CrawlModule;
import com.soulgalore.crawler.run.AbstractCrawl;
import org.apache.commons.cli.ParseException;

public class CrawlToSystemOut
extends AbstractCrawl {
    CrawlToSystemOut(String[] args) throws ParseException {
        super(args);
    }

    public static void main(String[] args) {
        try {
            CrawlToSystemOut crawl = new CrawlToSystemOut(args);
            crawl.crawl();
        }
        catch (ParseException e) {
            System.out.print(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void crawl() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new CrawlModule()});
        Crawler crawler = (Crawler)injector.getInstance(Crawler.class);
        CrawlerResult result = crawler.getUrls(this.getConfiguration());
        for (PageURL workingUrls : result.getUrls()) {
            System.out.println(workingUrls.getUrl());
        }
        crawler.shutdown();
    }
}

