/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.util;

import com.soulgalore.crawler.util.Auth;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public final class AuthUtil {
    private static final AuthUtil INSTANCE = new AuthUtil();

    private AuthUtil() {
    }

    public static AuthUtil getInstance() {
        return INSTANCE;
    }

    public Set<Auth> createAuthsFromString(String authInfo) {
        if ("".equals(authInfo) || authInfo == null) {
            return Collections.emptySet();
        }
        String[] parts = authInfo.split("\\,");
        HashSet<Auth> auths = new HashSet<Auth>();
        try {
            for (String auth : parts) {
                StringTokenizer tokenizer = new StringTokenizer(auth, ":");
                while (tokenizer.hasMoreTokens()) {
                    auths.add(new Auth(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken()));
                }
            }
            return auths;
        }
        catch (NoSuchElementException e) {
            StringBuilder b = new StringBuilder();
            for (String auth : parts) {
                b.append(auth);
            }
            throw new IllegalArgumentException("Auth configuration is configured wrongly:" + b.toString(), e);
        }
    }
}

