/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class HeaderUtil {
    private static final HeaderUtil INSTANCE = new HeaderUtil();

    private HeaderUtil() {
    }

    public static HeaderUtil getInstance() {
        return INSTANCE;
    }

    public Map<String, String> createHeadersFromString(String headersAndValues) {
        if (headersAndValues == null || headersAndValues.isEmpty()) {
            return Collections.emptyMap();
        }
        StringTokenizer token = new StringTokenizer(headersAndValues, "@");
        HashMap<String, String> theHeaders = new HashMap<String, String>(token.countTokens());
        while (token.hasMoreTokens()) {
            String headerAndValue = token.nextToken();
            if (headerAndValue.indexOf(":") == -1) {
                throw new IllegalArgumentException("Request headers wrongly configured, missing separator :" + headersAndValues);
            }
            String header = headerAndValue.substring(0, headerAndValue.indexOf(":"));
            String value = headerAndValue.substring(headerAndValue.indexOf(":") + 1, headerAndValue.length());
            theHeaders.put(header, value);
        }
        return theHeaders;
    }
}

