/*
 * Decompiled with CFR 0.152.
 */
package com.soulgalore.crawler.util;

public enum StatusCode {
    SC_SERVER_RESPONSE_TIMEOUT(580, "Response timed out"),
    SC_SERVER_RESPONSE_UNKNOWN(581, "Unknown error"),
    SC_MALFORMED_URI(582, "Malformed url"),
    SC_WRONG_CONTENT_TYPE(583, "Wrong content type"),
    SC_SERVER_REDIRECT_TO_NEW_DOMAIN(308, "Redirected to new domain");

    private final int code;
    private final String friendlyName;

    private StatusCode(int theCode, String theFriendlyName) {
        this.code = theCode;
        this.friendlyName = theFriendlyName;
    }

    public int getCode() {
        return this.code;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public static String toFriendlyName(int code) {
        for (StatusCode s : StatusCode.values()) {
            if (s.getCode() != code) continue;
            return s.getFriendlyName();
        }
        return String.valueOf(code);
    }

    public static boolean isResponseCodeOk(Integer responseCode) {
        return responseCode < 400;
    }
}

