/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.tools.benchmark.reporters;

import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.tools.benchmark.Metric;
import com.thoughtworks.xstream.tools.benchmark.Product;
import com.thoughtworks.xstream.tools.benchmark.Reporter;
import com.thoughtworks.xstream.tools.benchmark.Target;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HtmlReporter
implements Reporter {
    private final PrettyPrintWriter out;
    private final String title;
    private Metric currentMetric;
    private double largestMetricForTarget;
    private List resultsForTarget;

    public HtmlReporter(File htmlFile, String title) throws IOException {
        this.title = title;
        this.out = new PrettyPrintWriter((Writer)new FileWriter(htmlFile));
    }

    public void startBenchmark() {
        this.out.startNode("html");
        this.out.startNode("head");
        this.writeTag("title", this.title);
        this.writeTag("style", this.css(), "type", "text/css");
        this.out.endNode();
        this.out.startNode("body");
        this.writeTag("h1", this.title);
    }

    private String css() {
        StringBuffer css = new StringBuffer("\n");
        css.append("body, h1, h2, h3, td { font-family: arial; }\n");
        css.append("h1 { text-align: center; }\n");
        css.append("table, h3 { margin-left: 40px; }\n");
        css.append("table, td, th { border: 1px solid #999; border-collapse: collapse; font-size: smaller; }\n");
        css.append(".success { color: #090; }\n");
        css.append(".fail { color: #900; }\n");
        return css.toString();
    }

    public void startMetric(Metric metric) {
        this.writeTag("h2", metric.toString());
        this.currentMetric = metric;
    }

    public void startTarget(Target target) {
        this.writeTag("h3", target.toString());
        this.out.flush();
        this.largestMetricForTarget = 0.0;
        this.resultsForTarget = new ArrayList();
    }

    public void metricRecorded(Product product, double result) {
        if (result > this.largestMetricForTarget) {
            this.largestMetricForTarget = result;
        }
        this.resultsForTarget.add(new MetricResult(product, result));
    }

    public void metricFailed(Product product, Exception e) {
        this.resultsForTarget.add(new MetricResult(product, e));
    }

    public void endTarget(Target target) {
        this.out.startNode("table");
        this.out.startNode("tr");
        this.writeTag("th", "Product");
        this.writeTag("th", this.currentMetric.unit());
        this.out.endNode();
        for (MetricResult metricResult : this.resultsForTarget) {
            this.out.startNode("tr");
            this.writeTag("td", metricResult.product.toString());
            if (metricResult.exception == null) {
                this.writeTag("td", String.valueOf(metricResult.result), "class", "success");
                long percentage = Math.round(Math.abs(metricResult.result / this.largestMetricForTarget) * 100.0);
                this.out.startNode("td");
                this.out.addAttribute("style", "width: 400px;");
                this.writeTag("div", "", "style", "height: 100%; width: " + percentage + "%; background-color: blue;");
                this.out.endNode();
            } else {
                this.writeTag("td", "FAIL", "class", "fail");
                this.writeTag("td", metricResult.exception.toString());
            }
            this.out.endNode();
        }
        this.out.endNode();
        this.out.flush();
    }

    private void writeTag(String tag, String value) {
        this.out.startNode(tag);
        this.out.setValue(value);
        this.out.endNode();
    }

    private void writeTag(String tag, String value, String attributeName, String attributeValue) {
        this.out.startNode(tag);
        this.out.addAttribute(attributeName, attributeValue);
        this.out.setValue(value);
        this.out.endNode();
    }

    public void endMetric(Metric metric) {
    }

    public void endBenchmark() {
        this.writeTag("p", new Date().toString());
        this.out.endNode();
        this.out.endNode();
        this.out.close();
    }

    private static class MetricResult {
        private final Product product;
        private final double result;
        private final Exception exception;

        public MetricResult(Product product, double result) {
            this.result = result;
            this.product = product;
            this.exception = null;
        }

        public MetricResult(Product product, Exception exception) {
            this.product = product;
            this.result = 0.0;
            this.exception = exception;
        }
    }
}

