/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.gradle.nexus;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.codearte.gradle.nexus.BaseStagingTask;
import io.codearte.gradle.nexus.CloseRepositoryTask;
import io.codearte.gradle.nexus.logic.OperationRetrier;
import io.codearte.gradle.nexus.logic.RepositoryFetcher;
import io.codearte.gradle.nexus.logic.RepositoryReleaser;
import io.codearte.gradle.nexus.logic.RepositoryState;
import io.codearte.gradle.nexus.logic.RepositoryStateFetcher;
import io.codearte.gradle.nexus.logic.RetryingRepositoryTransitioner;
import io.codearte.gradle.nexus.logic.StagingProfileFetcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskAction;

public class ReleaseRepositoryTask
extends BaseStagingTask {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @TaskAction
    public void doAction() {
        StagingProfileFetcher stagingProfileFetcher = this.createFetcherWithGivenClient(this.createClient());
        RepositoryFetcher repositoryFetcher = this.createRepositoryFetcherWithGivenClient(this.createClient());
        this.tryToTakeStagingProfileIdFromCloseRepositoryTask();
        String stagingProfileId = this.fetchAndCacheStagingProfileId(stagingProfileFetcher);
        String repositoryId = this.getRepositoryIdFromCloseTaskOrFromServer(stagingProfileId, repositoryFetcher);
        this.releaseRepositoryByIdAndProfileIdWithRetrying(repositoryId, stagingProfileId);
    }

    private void tryToTakeStagingProfileIdFromCloseRepositoryTask() {
        if (this.getStagingProfileId() != null) {
            return;
        }
        String stagingProfileIdFromCloseRepositoryTask = this.getCloseRepositoryTask().getStagingProfileId();
        if (stagingProfileIdFromCloseRepositoryTask != null) {
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{stagingProfileIdFromCloseRepositoryTask}, new String[]{"Reusing staging profile id from closeRepository task: ", ""})));
            this.setStagingProfileId(stagingProfileIdFromCloseRepositoryTask);
        }
    }

    private CloseRepositoryTask getCloseRepositoryTask() {
        return (CloseRepositoryTask)((Object)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)((ProjectInternal)this.getProject()).getTasks().withType(CloseRepositoryTask.class), (int)0), CloseRepositoryTask.class));
    }

    /*
     * WARNING - void declaration
     */
    private String getRepositoryIdFromCloseTaskOrFromServer(String stagingProfileId, RepositoryFetcher repositoryFetcher) {
        void var2_2;
        Reference stagingProfileId2 = new Reference((Object)stagingProfileId);
        Reference repositoryFetcher2 = new Reference((Object)var2_2);
        String repositoryIdFromCloseTask = this.getCloseRepositoryTask().getStagingRepositoryId();
        if (repositoryIdFromCloseTask != null) {
            this.getLogger().debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{repositoryIdFromCloseTask}, new String[]{"Reusing staging repository id from closeRepository task: ", ""})));
            return repositoryIdFromCloseTask;
        }
        OperationRetrier retrier = this.createOperationRetrier();
        public class _getRepositoryIdFromCloseTaskOrFromServer_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryFetcher;
            private /* synthetic */ Reference stagingProfileId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getRepositoryIdFromCloseTaskOrFromServer_closure1(Object _outerInstance, Object _thisObject, Reference repositoryFetcher, Reference stagingProfileId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.repositoryFetcher = reference2 = repositoryFetcher;
                this.stagingProfileId = reference = stagingProfileId;
            }

            public Object doCall(Object it) {
                return ((RepositoryFetcher)this.repositoryFetcher.get()).getClosedRepositoryIdForStagingProfileId(ShortTypeHandling.castToString((Object)this.stagingProfileId.get()));
            }

            public RepositoryFetcher getRepositoryFetcher() {
                return (RepositoryFetcher)ScriptBytecodeAdapter.castToType((Object)this.repositoryFetcher.get(), RepositoryFetcher.class);
            }

            public String getStagingProfileId() {
                return ShortTypeHandling.castToString((Object)this.stagingProfileId.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRepositoryIdFromCloseTaskOrFromServer_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return ShortTypeHandling.castToString(retrier.doWithRetry(new _getRepositoryIdFromCloseTaskOrFromServer_closure1((Object)this, (Object)this, repositoryFetcher2, stagingProfileId2)));
    }

    private void releaseRepositoryByIdAndProfileIdWithRetrying(String repositoryId, String stagingProfileId) {
        RepositoryReleaser repositoryReleaser = this.createRepositoryReleaserWithGivenClient(this.createClient());
        RepositoryStateFetcher repositoryStateFetcher = this.createRepositoryStateFetcherWithGivenClient(this.createClient());
        OperationRetrier<RepositoryState> retrier = this.createOperationRetrier();
        RetryingRepositoryTransitioner retryingReleaser = new RetryingRepositoryTransitioner(repositoryReleaser, repositoryStateFetcher, retrier);
        retryingReleaser.performWithRepositoryIdAndStagingProfileId(repositoryId, stagingProfileId);
        this.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{repositoryId}, new String[]{"Repository '", "' has been effectively released"})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ReleaseRepositoryTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }
}

