/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.gradle.nexus.infra;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovyx.net.http.ContentType;
import groovyx.net.http.HttpResponseDecorator;
import groovyx.net.http.HttpResponseException;
import groovyx.net.http.RESTClient;
import io.codearte.gradle.nexus.infra.NexusHttpResponseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifiedHttpJsonRestClient
implements GroovyObject {
    private final RESTClient restClient;
    private final String username;
    private final String password;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public SimplifiedHttpJsonRestClient(RESTClient rESTClient, String string, String string2) {
        void password;
        void username;
        void restClient;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = restClient;
        this.restClient = var5_5;
        void var6_6 = username;
        this.username = var6_6;
        void var7_7 = password;
        this.password = var7_7;
        String string3 = "application/json";
        DefaultGroovyMethods.putAt((Map)((RESTClient)restClient).getHeaders(), (Object)"Content-Type", (Object)string3);
    }

    public Map get(String uri) {
        return (Map)ScriptBytecodeAdapter.castToType((Object)this.sendRequestHandlingErrors(uri, null, (Closure<Object>)ScriptBytecodeAdapter.getMethodPointer((Object)this.restClient, (String)"get"), RequestType.GET).getData(), Map.class);
    }

    public void post(String uri, Map content) {
        this.sendRequestHandlingErrors(uri, content, (Closure<Object>)ScriptBytecodeAdapter.getMethodPointer((Object)this.restClient, (String)"post"), RequestType.POST);
    }

    private HttpResponseDecorator sendRequestHandlingErrors(String uri, Map content, Closure<Object> clientMethodHandler, RequestType requestTypeName) {
        HttpResponseDecorator httpResponseDecorator = this.prepareAndSendRequest(uri, content, clientMethodHandler, requestTypeName);
        try {
            return httpResponseDecorator;
        }
        catch (HttpResponseException e) {
            Object v1;
            HttpResponseDecorator resp = e.getResponse();
            Object[] objectArray = new Object[3];
            objectArray[0] = resp.getStatusLine().getStatusCode();
            objectArray[1] = resp.getStatusLine().getReasonPhrase();
            Object object = resp.getData();
            objectArray[2] = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "<empty>";
            String message = ShortTypeHandling.castToString((Object)new GStringImpl(objectArray, new String[]{"", ": ", ", body: ", ""}));
            if (log.isWarnEnabled()) {
                log.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{requestTypeName, message}, new String[]{"", " request failed. ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            throw (Throwable)new NexusHttpResponseException(e.getStatusCode(), message, e);
        }
    }

    private HttpResponseDecorator prepareAndSendRequest(String uri, Map content, Closure<Object> clientMethodHandler, RequestType requestType) {
        Object v1;
        this.setUriAndAuthentication(uri);
        Map params = this.createAndInitializeCallParametersMap();
        if (content != null) {
            Object v0;
            Map map = content;
            ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)params, (String)"body");
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{requestType, content}, new String[]{"", " request content: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{requestType, uri}, new String[]{"", " request URL: ", ""})));
            v1 = null;
        } else {
            v1 = null;
        }
        return (HttpResponseDecorator)ScriptBytecodeAdapter.castToType((Object)clientMethodHandler.call((Object)params), HttpResponseDecorator.class);
    }

    private void setUriAndAuthentication(String uri) {
        String string = uri;
        this.restClient.setUri((Object)string);
        if (this.username != null) {
            this.restClient.getAuth().basic(this.username, this.password);
        }
    }

    private Map createAndInitializeCallParametersMap() {
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contentType", ContentType.JSON});
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SimplifiedHttpJsonRestClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SimplifiedHttpJsonRestClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(SimplifiedHttpJsonRestClient.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SimplifiedHttpJsonRestClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"io.codearte.gradle.nexus.infra.SimplifiedHttpJsonRestClient");
    }

    final class RequestType
    extends Enum<RequestType>
    implements GroovyObject {
        public static final /* enum */ RequestType GET;
        public static final /* enum */ RequestType POST;
        public static final RequestType MIN_VALUE;
        public static final RequestType MAX_VALUE;
        private static final /* synthetic */ RequestType[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public RequestType(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum io.codearte.gradle.nexus.infra.SimplifiedHttpJsonRestClient$RequestType was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public RequestType() {
            this(new LinkedHashMap());
        }

        public static final RequestType[] values() {
            return (RequestType[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), RequestType[].class);
        }

        public /* synthetic */ RequestType next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                Integer n = 0;
                ordinal = n;
            }
            return (RequestType)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RequestType.class);
        }

        public /* synthetic */ RequestType previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (RequestType)ShortTypeHandling.castToEnum((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), RequestType.class);
        }

        public static RequestType valueOf(String name) {
            return (RequestType)ShortTypeHandling.castToEnum((Object)((Object)Enum.valueOf(RequestType.class, name)), RequestType.class);
        }

        public static final /* synthetic */ RequestType $INIT(Object ... para) {
            RequestType requestType;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, RequestType.class)) {
                case -1348271900: {
                    RequestType requestType2;
                    requestType = requestType2;
                    Object[] objectArray2 = objectArray;
                    requestType2 = new RequestType();
                    break;
                }
                case -242181752: {
                    RequestType requestType2;
                    requestType = requestType2;
                    Object[] objectArray2 = objectArray;
                    requestType2 = new RequestType((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return requestType;
        }

        static {
            RequestType requestType;
            RequestType requestType2;
            RequestType requestType3;
            RequestType requestType4;
            GET = requestType4 = RequestType.$INIT("GET", 0);
            POST = requestType3 = RequestType.$INIT("POST", 1);
            MIN_VALUE = requestType2 = GET;
            MAX_VALUE = requestType = POST;
            RequestType[] requestTypeArray = new RequestType[]{GET, POST};
            $VALUES = requestTypeArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != RequestType.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

