/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.gradle.nexus.logic;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import io.codearte.gradle.nexus.infra.SimplifiedHttpJsonRestClient;
import io.codearte.gradle.nexus.infra.WrongNumberOfRepositories;
import io.codearte.gradle.nexus.logic.BaseOperationExecutor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFetcher
extends BaseOperationExecutor {
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public RepositoryFetcher(SimplifiedHttpJsonRestClient client, String nexusUrl) {
        super(client, nexusUrl);
    }

    public String getOpenRepositoryIdForStagingProfileId(String stagingProfileId) {
        return this.getRepositoryIdWithGivenStateForStagingProfileId("open", stagingProfileId);
    }

    public String getClosedRepositoryIdForStagingProfileId(String stagingProfileId) {
        return this.getRepositoryIdWithGivenStateForStagingProfileId("closed", stagingProfileId);
    }

    private String getRepositoryIdWithGivenStateForStagingProfileId(String state, String stagingProfileId) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{state, stagingProfileId}, new String[]{"Getting '", "' repository for staging profile '", "'"})));
            v0 = null;
        } else {
            v0 = null;
        }
        Map allStagingRepositoriesResponseAsMap = this.client.get(StringGroovyMethods.plus((String)this.nexusUrl, (CharSequence)new GStringImpl(new Object[]{stagingProfileId}, new String[]{"/staging/profile_repositories/", ""})));
        return this.parseResponseAndGetRepositoryIdInGivenState(allStagingRepositoriesResponseAsMap, state);
    }

    private String parseResponseAndGetRepositoryIdInGivenState(Map<String, List> allStagingRepositoriesResponseAsMap, String repositoryState) {
        Object v0;
        Map repository = this.verifyThatOneRepositoryAndReturnIt(allStagingRepositoriesResponseAsMap, repositoryState);
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{repositoryState, repository.get("repositoryId")}, new String[]{"Received 1 '", "' repository with id: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return ShortTypeHandling.castToString(repository.get("repositoryId"));
    }

    private Map verifyThatOneRepositoryAndReturnIt(Map<String, List> responseAsMap, String repositoryState) {
        Reference repositoryState2 = new Reference((Object)repositoryState);
        public class _verifyThatOneRepositoryAndReturnIt_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference repositoryState;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _verifyThatOneRepositoryAndReturnIt_closure1(Object _outerInstance, Object _thisObject, Reference repositoryState) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.repositoryState = reference = repositoryState;
            }

            public Object doCall(Map repository) {
                return ScriptBytecodeAdapter.compareEqual(repository.get("type"), (Object)this.repositoryState.get());
            }

            public Object call(Map repository) {
                return this.doCall(repository);
            }

            public String getRepositoryState() {
                return ShortTypeHandling.castToString((Object)this.repositoryState.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _verifyThatOneRepositoryAndReturnIt_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        _verifyThatOneRepositoryAndReturnIt_closure1 repositoryInGivenState = new _verifyThatOneRepositoryAndReturnIt_closure1(this, this, repositoryState2);
        int numberOfRepositories = (Integer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.count((Iterable)((Iterable)ScriptBytecodeAdapter.castToType((Object)responseAsMap.get("data"), Iterable.class)), (Closure)repositoryInGivenState), Integer.class);
        if (numberOfRepositories != 1) {
            throw (Throwable)new WrongNumberOfRepositories(numberOfRepositories, (String)repositoryState2.get());
        }
        return (Map)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.find((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)responseAsMap.get("data"), Collection.class)), (Closure)repositoryInGivenState), Map.class);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RepositoryFetcher.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"io.codearte.gradle.nexus.logic.RepositoryFetcher");
    }
}

