/*
 * Decompiled with CFR 0.152.
 */
package io.codearte.gradle.nexus.logic;

import groovy.lang.MetaClass;
import io.codearte.gradle.nexus.exception.RepositoryInTransitionException;
import io.codearte.gradle.nexus.infra.NexusHttpResponseException;
import io.codearte.gradle.nexus.infra.SimplifiedHttpJsonRestClient;
import io.codearte.gradle.nexus.logic.BaseOperationExecutor;
import io.codearte.gradle.nexus.logic.RepositoryState;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryStateFetcher
extends BaseOperationExecutor {
    private static final int NOT_FOUND_RESPONSE_CODE = 404;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public RepositoryStateFetcher(SimplifiedHttpJsonRestClient client, String nexusUrl) {
        super(client, nexusUrl);
    }

    public RepositoryState getNonTransitioningRepositoryStateById(String repoId) {
        RepositoryState repositoryState = this.getRepoAssertingAndReturningState(repoId);
        try {
            return repositoryState;
        }
        catch (NexusHttpResponseException e) {
            RepositoryState repositoryState2 = this.handleGivenRepositoryNotFoundOrRethrowException(repoId, e);
            return repositoryState2;
        }
    }

    private RepositoryState getRepoAssertingAndReturningState(String repoId) {
        Map<String, Object> repoResponseAsMap = this.getRepositoryWithId(repoId);
        this.parseResponseAndThrowExceptionIfInTransition(repoResponseAsMap, repoId);
        return this.parseRepoStateFromRepsponse(repoResponseAsMap);
    }

    private Map<String, Object> getRepositoryWithId(String repoId) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{repoId}, new String[]{"Getting repository '", "'"})));
            v0 = null;
        } else {
            v0 = null;
        }
        Map repoResponseAsMap = this.client.get(StringGroovyMethods.plus((String)this.nexusUrl, (CharSequence)new GStringImpl(new Object[]{repoId}, new String[]{"/staging/repository/", ""})));
        return repoResponseAsMap;
    }

    private void parseResponseAndThrowExceptionIfInTransition(Map<String, Object> repoResponseAsMap, String repoId) {
        if (ScriptBytecodeAdapter.compareEqual((Object)repoResponseAsMap.get("transitioning"), (Object)false)) {
            return;
        }
        throw (Throwable)new RepositoryInTransitionException(repoId, ShortTypeHandling.castToString((Object)repoResponseAsMap.get("type")));
    }

    private RepositoryState parseRepoStateFromRepsponse(Map<String, Object> repoResponseAsMap) {
        return RepositoryState.parseString(ShortTypeHandling.castToString((Object)repoResponseAsMap.get("type")));
    }

    private RepositoryState handleGivenRepositoryNotFoundOrRethrowException(String repoId, NexusHttpResponseException responseException) {
        if (responseException.getStatusCode() == NOT_FOUND_RESPONSE_CODE && this.isErrorMessageForGivenNotFoundRepository(repoId, responseException.getMessage())) {
            return RepositoryState.NOT_FOUND;
        }
        throw (Throwable)responseException;
    }

    private boolean isErrorMessageForGivenNotFoundRepository(String repoId, String message) {
        return message.contains("No such repository") && message.contains(repoId);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RepositoryStateFetcher.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"io.codearte.gradle.nexus.logic.RepositoryStateFetcher");
    }
}

