/*
 * Decompiled with CFR 0.152.
 */
package org.boon.json;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.boon.IO;
import org.boon.di.Creator;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;

public class JsonCreator {
    public static <T> T createFromJsonMap(Class<T> type, String str) {
        Map<String, Object> config = new JsonParserFactory().createLaxParser().parseMap(str);
        return Creator.create(type, config);
    }

    public static <T> T createFromJsonMapResource(Class<T> type, String resource) {
        Map<String, Object> config = null;
        JsonParserAndMapper laxParser = new JsonParserFactory().createLaxParser();
        if (resource.endsWith(".json")) {
            config = laxParser.parseMap(IO.read(resource));
        } else if (resource.endsWith("/")) {
            config = new LinkedHashMap<String, Object>();
            JsonCreator.handleDir(config, laxParser, resource);
        }
        return Creator.create(type, config);
    }

    private static void handleDir(Map<String, Object> config, JsonParserAndMapper laxParser, String resource) {
        List<String> jsonFiles = IO.listByExt(resource, ".json");
        for (String jsonFile : jsonFiles) {
            String contents = IO.read(jsonFile);
            Map<String, Object> fileConfig = laxParser.parseMap(contents);
            config.putAll(fileConfig);
        }
    }
}

