/*
 * Decompiled with CFR 0.152.
 */
package org.boon.primitive;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.boon.Exceptions;
import org.boon.Universal;
import org.boon.core.reflection.Invoker;

public class Dbl {
    public static double[] grow(double[] array, int size) {
        Exceptions.requireNonNull(array);
        double[] newArray = new double[array.length + size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static double[] grow(double[] array) {
        Exceptions.requireNonNull(array);
        double[] newArray = new double[array.length * 2];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static double[] shrink(double[] array, int size) {
        Exceptions.requireNonNull(array);
        double[] newArray = new double[array.length - size];
        System.arraycopy(array, 0, newArray, 0, array.length - size);
        return newArray;
    }

    public static double[] compact(double[] array) {
        Exceptions.requireNonNull(array);
        int nullCount = 0;
        for (double ch : array) {
            if (ch != 0.0) continue;
            ++nullCount;
        }
        double[] newArray = new double[array.length - nullCount];
        int j = 0;
        for (double ch : array) {
            if (ch == 0.0) continue;
            newArray[j] = ch;
            ++j;
        }
        return newArray;
    }

    public static double[] arrayOfDouble(int size) {
        return new double[size];
    }

    @Universal
    public static double[] array(double ... array) {
        Exceptions.requireNonNull(array);
        return array;
    }

    @Universal
    public static int len(double[] array) {
        return array.length;
    }

    @Universal
    public static double idx(double[] array, int index) {
        int i = Dbl.calculateIndex(array, index);
        return array[i];
    }

    @Universal
    public static void idx(double[] array, int index, double value) {
        int i = Dbl.calculateIndex(array, index);
        array[i] = value;
    }

    @Universal
    public static double[] sliceOf(double[] array, int startIndex, int endIndex) {
        return Dbl.slc(array, startIndex, endIndex);
    }

    @Universal
    public static double[] slc(double[] array, int startIndex, int endIndex) {
        int start = Dbl.calculateIndex(array, startIndex);
        int end = Dbl.calculateEndIndex(array, endIndex);
        int newLength = end - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, end index %d, length %d", startIndex, endIndex, array.length));
        }
        double[] newArray = new double[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static double[] slc(double[] array, int startIndex) {
        int start = Dbl.calculateIndex(array, startIndex);
        int newLength = array.length - start;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", startIndex, array.length));
        }
        double[] newArray = new double[newLength];
        System.arraycopy(array, start, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static double[] endSliceOf(double[] array, int endIndex) {
        return Dbl.slcEnd(array, endIndex);
    }

    @Universal
    public static double[] slcEnd(double[] array, int endIndex) {
        int end = Dbl.calculateEndIndex(array, endIndex);
        int newLength = end;
        if (newLength < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("start index %d, length %d", endIndex, array.length));
        }
        double[] newArray = new double[newLength];
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    @Universal
    public static boolean in(double value, double[] array) {
        for (double currentValue : array) {
            if (currentValue != value) continue;
            return true;
        }
        return false;
    }

    @Universal
    public static double[] copy(double[] array) {
        double[] newArray = new double[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Universal
    public static double[] add(double[] array, double v) {
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = v;
        return newArray;
    }

    @Universal
    public static double[] add(double[] array, double[] array2) {
        double[] newArray = new double[array.length + array2.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(array2, 0, newArray, array.length, array2.length);
        return newArray;
    }

    @Universal
    public static double[] insert(double[] array, int idx, double v) {
        Exceptions.requireNonNull(array);
        if (idx >= array.length) {
            return Dbl.add(array, v);
        }
        int index = Dbl.calculateIndex(array, idx);
        double[] newArray = new double[array.length + 1];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int remainingIndex = array.length - index;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + 1, remainingIndex);
        }
        newArray[index] = v;
        return newArray;
    }

    @Universal
    public static double[] insert(double[] array, int fromIndex, double[] values) {
        if (fromIndex >= array.length) {
            return Dbl.add(array, values);
        }
        int index = Dbl.calculateIndex(array, fromIndex);
        double[] newArray = new double[array.length + values.length];
        if (index != 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        boolean lastIndex = index == array.length - 1;
        int toIndex = index + values.length;
        int remainingIndex = newArray.length - toIndex;
        if (lastIndex) {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        } else {
            System.arraycopy(array, index, newArray, index + values.length, remainingIndex);
        }
        int i = index;
        int j = 0;
        while (i < toIndex) {
            newArray[i] = values[j];
            ++i;
            ++j;
        }
        return newArray;
    }

    private static int calculateIndex(double[] array, int originalIndex) {
        int length = array.length;
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= length) {
            index = length - 1;
        }
        return index;
    }

    private static int calculateEndIndex(double[] array, int originalIndex) {
        int length = array.length;
        Exceptions.requireNonNull(array, "array cannot be null");
        int index = originalIndex;
        if (index < 0) {
            index = length + index;
        }
        if (index < 0) {
            index = 0;
        }
        if (index > length) {
            index = length;
        }
        return index;
    }

    public static boolean equalsOrDie(double[] expected, double[] got) {
        if (expected.length != got.length) {
            Exceptions.die("Lengths did not match, expected length", expected.length, "but got", got.length);
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            Exceptions.die("value at index did not match index", index, "expected value", expected[index], "but got", got[index]);
        }
        return true;
    }

    public static boolean equals(double[] expected, double[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = 0; index < expected.length; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static double reduceBy(double[] array, ReduceBy reduceBy) {
        double sum = 0.0;
        for (double v : array) {
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static double reduceBy(double[] array, int start, int length, ReduceBy reduceBy) {
        double sum = 0.0;
        for (int index = start; index < length; ++index) {
            double v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static double reduceBy(double[] array, int length, ReduceBy reduceBy) {
        double sum = 0.0;
        for (int index = 0; index < length; ++index) {
            double v = array[index];
            sum = reduceBy.reduce(sum, v);
        }
        return sum;
    }

    public static <T> double reduceBy(double[] array, T object) {
        if (object.getClass().isAnonymousClass()) {
            return Dbl.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (double v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Dbl.reduceByR(array, object);
        }
    }

    public static <T> double reduceBy(double[] array, T object, String methodName) {
        if (object.getClass().isAnonymousClass()) {
            return Dbl.reduceByR(array, object, methodName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object, methodName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (double v : array) {
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Dbl.reduceByR(array, object, methodName);
        }
    }

    private static <T> double reduceByR(double[] array, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            double sum = 0.0;
            for (double v : array) {
                sum = (Double)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    private static <T> double reduceByR(double[] array, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            double sum = 0.0;
            for (double v : array) {
                sum = (Double)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    private static <T> double reduceByR(double[] array, int length, T object, String methodName) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object, methodName);
            double sum = 0.0;
            for (int index = 0; index < length; ++index) {
                double v = array[index];
                sum = (Double)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    private static <T> double reduceByR(double[] array, int length, T object) {
        try {
            Method method = Invoker.invokeReducerLongIntReturnLongMethod(object);
            double sum = 0.0;
            for (int index = 0; index < length; ++index) {
                double v = array[index];
                sum = (Double)method.invoke(object, sum, v);
            }
            return sum;
        }
        catch (Throwable throwable) {
            return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
        }
    }

    public static double reduceBy(double[] array, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Dbl.reduceByR(array, length, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (int index = 0; index < length; ++index) {
                    double v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Dbl.reduceByR(array, length, object);
        }
    }

    public static double reduceBy(double[] array, int length, Object function, String functionName) {
        if (function.getClass().isAnonymousClass()) {
            return Dbl.reduceByR(array, length, function, functionName);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(function, functionName);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (int index = 0; index < length; ++index) {
                    double v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Dbl.reduceByR(array, length, function, functionName);
        }
    }

    public static double reduceBy(double[] array, int start, int length, Object object) {
        if (object.getClass().isAnonymousClass()) {
            return Dbl.reduceByR(array, object);
        }
        try {
            ConstantCallSite callSite = Invoker.invokeReducerLongIntReturnLongMethodHandle(object);
            MethodHandle methodHandle = callSite.dynamicInvoker();
            try {
                double sum = 0.0;
                for (int index = start; index < length; ++index) {
                    double v = array[index];
                    sum = methodHandle.invokeExact(sum, v);
                }
                return sum;
            }
            catch (Throwable throwable) {
                return Exceptions.handle(Long.class, throwable, "Unable to perform reduceBy").longValue();
            }
        }
        catch (Exception ex) {
            return Dbl.reduceByR(array, object);
        }
    }

    public static boolean equalsOrDie(double expected, double got) {
        if (expected != got) {
            return Exceptions.die(Boolean.class, "Expected was", expected, "but we got ", got);
        }
        return true;
    }

    public static boolean equals(double expected, double got) {
        return expected == got;
    }

    public static double sum(double[] values) {
        return Dbl.sum(values, 0, values.length);
    }

    public static double sum(double[] values, int length) {
        return Dbl.sum(values, 0, length);
    }

    public static double sum(double[] values, int start, int length) {
        double sum = 0.0;
        for (int index = start; index < length; ++index) {
            sum += values[index];
        }
        if (sum < (double)1.4E-45f) {
            Exceptions.die("overflow the sum is too small", sum);
        }
        if (sum > 3.4028234663852886E38) {
            Exceptions.die("overflow the sum is too big", sum);
        }
        return sum;
    }

    public static double max(double[] values, int start, int length) {
        double max = 1.4E-45f;
        for (int index = start; index < length; ++index) {
            if (!(values[index] > max)) continue;
            max = values[index];
        }
        return max;
    }

    public static double max(double[] values) {
        return Dbl.max(values, 0, values.length);
    }

    public static double max(double[] values, int length) {
        return Dbl.max(values, 0, length);
    }

    public static double min(double[] values, int start, int length) {
        double min = 3.4028234663852886E38;
        for (int index = start; index < length; ++index) {
            if (!(values[index] < min)) continue;
            min = values[index];
        }
        return min;
    }

    public static double min(double[] values) {
        return Dbl.min(values, 0, values.length);
    }

    public static double min(double[] values, int length) {
        return Dbl.min(values, 0, length);
    }

    private static double mean(double[] values, int start, int length) {
        double mean = Dbl.sum(values, start, length) / (double)length;
        return mean;
    }

    public static double mean(double[] values, int length) {
        return Dbl.mean(values, 0, length);
    }

    public static double mean(double[] values) {
        return Dbl.mean(values, 0, values.length);
    }

    public static double variance(double[] values, int start, int length) {
        return Dbl.varianceDouble(values, start, length);
    }

    public static double varianceDouble(double[] values, int start, int length) {
        double mean = Dbl.mean(values, start, length);
        double temp = 0.0;
        for (int index = start; index < length; ++index) {
            double a = values[index];
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)length;
    }

    public static double variance(double[] values, int length) {
        return Dbl.varianceDouble(values, 0, length);
    }

    public static double variance(double[] values) {
        return Dbl.varianceDouble(values, 0, values.length);
    }

    public static double standardDeviation(double[] values, int start, int length) {
        double variance = Dbl.varianceDouble(values, start, length);
        return Math.sqrt(variance);
    }

    public static double standardDeviation(double[] values, int length) {
        double variance = Dbl.varianceDouble(values, 0, length);
        return Math.sqrt(variance);
    }

    public static double standardDeviation(double[] values) {
        double variance = Dbl.varianceDouble(values, 0, values.length);
        return Math.sqrt(variance);
    }

    public static double median(double[] values, int start, int length) {
        double[] sorted = new double[length];
        System.arraycopy(values, start, sorted, 0, length);
        Arrays.sort(sorted);
        if (length % 2 == 0) {
            int middle = sorted.length / 2;
            double median = (sorted[middle - 1] + sorted[middle]) / 2.0;
            return median;
        }
        return sorted[sorted.length / 2];
    }

    public static double median(double[] values, int length) {
        return Dbl.median(values, 0, length);
    }

    public static double median(double[] values) {
        return Dbl.median(values, 0, values.length);
    }

    public static boolean equals(int start, int end, double[] expected, double[] got) {
        if (expected.length != got.length) {
            return false;
        }
        for (int index = start; index < end; ++index) {
            if (expected[index] == got[index]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (double element : array) {
            long bits = Double.doubleToLongBits(element);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public static int hashCode(int start, int end, double[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index = start; index < end; ++index) {
            long bits = Double.doubleToLongBits(array[index]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public static interface ReduceBy {
        public double reduce(double var1, double var3);
    }
}

