/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxUsing;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoUsing<T, S>
extends Mono<T>
implements Fuseable,
Scannable {
    final Callable<S> resourceSupplier;
    final Function<? super S, ? extends Mono<? extends T>> sourceFactory;
    final Consumer<? super S> resourceCleanup;
    final boolean eager;

    MonoUsing(Callable<S> resourceSupplier, Function<? super S, ? extends Mono<? extends T>> sourceFactory, Consumer<? super S> resourceCleanup, boolean eager) {
        this.resourceSupplier = Objects.requireNonNull(resourceSupplier, "resourceSupplier");
        this.sourceFactory = Objects.requireNonNull(sourceFactory, "sourceFactory");
        this.resourceCleanup = Objects.requireNonNull(resourceCleanup, "resourceCleanup");
        this.eager = eager;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Mono<T> p;
        S resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        try {
            p = Objects.requireNonNull(this.sourceFactory.apply(resource), "The sourceFactory returned a null value");
        }
        catch (Throwable e) {
            try {
                this.resourceCleanup.accept(resource);
            }
            catch (Throwable ex) {
                e = Exceptions.addSuppressed(ex, Operators.onOperatorError(e, actual.currentContext()));
            }
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        if (p instanceof Fuseable) {
            p.subscribe(new FluxUsing.UsingFuseableSubscriber<T, S>(actual, this.resourceCleanup, resource, this.eager));
        } else if (actual instanceof Fuseable.ConditionalSubscriber) {
            p.subscribe(new FluxUsing.UsingConditionalSubscriber((Fuseable.ConditionalSubscriber)actual, this.resourceCleanup, resource, this.eager));
        } else {
            p.subscribe(new FluxUsing.UsingSubscriber<T, S>(actual, this.resourceCleanup, resource, this.eager));
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

