/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.prepare;

import com.google.common.collect.Lists;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareCallback;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLUnit;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SQLExecutePrepareTemplate {
    private final int maxConnectionsSizePerQuery;

    public Collection<ShardingExecuteGroup<StatementExecuteUnit>> getExecuteUnitGroups(Collection<RouteUnit> routeUnits, SQLExecutePrepareCallback callback) throws SQLException {
        return this.getSynchronizedExecuteUnitGroups(routeUnits, callback);
    }

    private Collection<ShardingExecuteGroup<StatementExecuteUnit>> getSynchronizedExecuteUnitGroups(Collection<RouteUnit> routeUnits, SQLExecutePrepareCallback callback) throws SQLException {
        Map<String, List<SQLUnit>> sqlUnitGroups = this.getSQLUnitGroups(routeUnits);
        LinkedList<ShardingExecuteGroup<StatementExecuteUnit>> result = new LinkedList<ShardingExecuteGroup<StatementExecuteUnit>>();
        for (Map.Entry<String, List<SQLUnit>> entry : sqlUnitGroups.entrySet()) {
            result.addAll(this.getSQLExecuteGroups(entry.getKey(), entry.getValue(), callback));
        }
        return result;
    }

    private Map<String, List<SQLUnit>> getSQLUnitGroups(Collection<RouteUnit> routeUnits) {
        LinkedHashMap<String, List<SQLUnit>> result = new LinkedHashMap<String, List<SQLUnit>>(routeUnits.size(), 1.0f);
        for (RouteUnit each : routeUnits) {
            if (!result.containsKey(each.getDataSourceName())) {
                result.put(each.getDataSourceName(), new LinkedList());
            }
            ((List)result.get(each.getDataSourceName())).add(each.getSqlUnit());
        }
        return result;
    }

    private List<ShardingExecuteGroup<StatementExecuteUnit>> getSQLExecuteGroups(String dataSourceName, List<SQLUnit> sqlUnits, SQLExecutePrepareCallback callback) throws SQLException {
        LinkedList<ShardingExecuteGroup<StatementExecuteUnit>> result = new LinkedList<ShardingExecuteGroup<StatementExecuteUnit>>();
        int desiredPartitionSize = Math.max(sqlUnits.size() / this.maxConnectionsSizePerQuery, 1);
        List sqlUnitPartitions = Lists.partition(sqlUnits, (int)desiredPartitionSize);
        ConnectionMode connectionMode = this.maxConnectionsSizePerQuery < sqlUnits.size() ? ConnectionMode.CONNECTION_STRICTLY : ConnectionMode.MEMORY_STRICTLY;
        List<Connection> connections = callback.getConnections(connectionMode, dataSourceName, sqlUnitPartitions.size());
        int count = 0;
        for (List each : sqlUnitPartitions) {
            result.add(this.getSQLExecuteGroup(connectionMode, connections.get(count++), dataSourceName, each, callback));
        }
        return result;
    }

    private ShardingExecuteGroup<StatementExecuteUnit> getSQLExecuteGroup(ConnectionMode connectionMode, Connection connection, String dataSourceName, List<SQLUnit> sqlUnitGroup, SQLExecutePrepareCallback callback) throws SQLException {
        LinkedList<StatementExecuteUnit> result = new LinkedList<StatementExecuteUnit>();
        for (SQLUnit each : sqlUnitGroup) {
            result.add(callback.createStatementExecuteUnit(connection, new RouteUnit(dataSourceName, each), connectionMode));
        }
        return new ShardingExecuteGroup<StatementExecuteUnit>(result);
    }

    @ConstructorProperties(value={"maxConnectionsSizePerQuery"})
    public SQLExecutePrepareTemplate(int maxConnectionsSizePerQuery) {
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
    }
}

