/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.CollectionSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.ColumnDefinitionExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.column.ColumnDefinitionSegment;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class AddColumnExtractor
implements CollectionSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionPhraseExtractor = new ColumnDefinitionExtractor();

    public Collection<ColumnDefinitionSegment> extract(ParserRuleContext ancestorNode) {
        Collection<ParserRuleContext> addColumnNodes = ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ADD_COLUMN);
        if (addColumnNodes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ColumnDefinitionSegment> result = new LinkedList<ColumnDefinitionSegment>();
        for (ParserRuleContext each : addColumnNodes) {
            this.extractAddColumn(each, result);
        }
        return result;
    }

    private void extractAddColumn(ParserRuleContext addColumnNode, Collection<ColumnDefinitionSegment> result) {
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(addColumnNode, RuleName.COLUMN_DEFINITION)) {
            Optional<ColumnDefinitionSegment> columnDefinition = this.columnDefinitionPhraseExtractor.extract(each);
            if (!columnDefinition.isPresent()) continue;
            ((ColumnDefinitionSegment)columnDefinition.get()).setAdd(true);
            this.postExtractColumnDefinition((ParseTree)addColumnNode, (ColumnDefinitionSegment)columnDefinition.get());
            result.add((ColumnDefinitionSegment)columnDefinition.get());
        }
    }

    protected void postExtractColumnDefinition(ParseTree ancestorNode, ColumnDefinitionSegment columnDefinition) {
    }
}

