/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableSegment;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.util.SQLUtil;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;

public final class TableNameExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<TableSegment> extract(ParserRuleContext ancestorNode) {
        int skippedSchemaNameLength;
        Optional schemaName;
        String tableName;
        Optional<ParserRuleContext> tableNameNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.TABLE_NAME);
        if (!tableNameNode.isPresent()) {
            return Optional.absent();
        }
        String tableText = ((ParserRuleContext)tableNameNode.get()).getText();
        if (tableText.contains(Symbol.DOT.getLiterals())) {
            List tableTextSegments = Splitter.on((String)Symbol.DOT.getLiterals()).splitToList((CharSequence)tableText);
            tableName = (String)tableTextSegments.get(tableTextSegments.size() - 1);
            schemaName = Optional.of(tableTextSegments.get(tableTextSegments.size() - 2));
            skippedSchemaNameLength = tableText.lastIndexOf(Symbol.DOT.getLiterals()) + 1;
        } else {
            tableName = tableText;
            schemaName = Optional.absent();
            skippedSchemaNameLength = 0;
        }
        TableToken tableToken = new TableToken(((ParserRuleContext)tableNameNode.get()).getStart().getStartIndex(), skippedSchemaNameLength, tableName);
        TableSegment result = new TableSegment(SQLUtil.getExactlyValue(tableName), tableToken);
        result.setSchemaName((String)schemaName.orNull());
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(((ParserRuleContext)tableNameNode.get()).getParent(), RuleName.ALIAS);
        if (aliasNode.isPresent()) {
            result.setAlias(((ParserRuleContext)aliasNode.get()).getText());
            result.setAliasStartPosition(((ParserRuleContext)aliasNode.get()).getStart().getStartIndex());
        }
        return Optional.of((Object)result);
    }
}

