/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.filler.impl;

import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.antlr.filler.SQLStatementFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.FromWhereFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.GroupByFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.OrderByFiller;
import io.shardingsphere.core.parsing.antlr.filler.impl.SelectClauseFiller;
import io.shardingsphere.core.parsing.antlr.sql.segment.SQLSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.expr.SubquerySegment;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class SubqueryFiller
implements SQLStatementFiller {
    @Override
    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        SubquerySegment subquerySegment = (SubquerySegment)sqlSegment;
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        SelectStatement subqueryStatement = new SelectStatement();
        selectStatement.getSubQueryStatements().add(subqueryStatement);
        if (subquerySegment.getSelectClauseSegment().isPresent()) {
            new SelectClauseFiller().fill((SQLSegment)subquerySegment.getSelectClauseSegment().get(), subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
        if (subquerySegment.getFromWhereSegment().isPresent()) {
            new FromWhereFiller().fill((SQLSegment)subquerySegment.getFromWhereSegment().get(), subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
        if (!subquerySegment.isSubqueryInFrom()) {
            return;
        }
        if (subquerySegment.getGroupBySegment().isPresent()) {
            new GroupByFiller().fill((SQLSegment)subquerySegment.getGroupBySegment().get(), subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
        if (subquerySegment.getOrderBySegment().isPresent()) {
            new OrderByFiller().fill((SQLSegment)subquerySegment.getOrderBySegment().get(), subqueryStatement, sql, shardingRule, shardingTableMetaData);
        }
    }
}

