/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.complex;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.routing.type.TableUnits;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CartesianRoutingEngine
implements RoutingEngine {
    private final Collection<RoutingResult> routingResults;

    @Override
    public RoutingResult route() {
        RoutingResult result = new RoutingResult();
        for (Map.Entry<String, Set<String>> entry : this.getDataSourceLogicTablesMap().entrySet()) {
            List<Set<String>> actualTableGroups = this.getActualTableGroups(entry.getKey(), entry.getValue());
            List<Set<RoutingTable>> routingTableGroups = this.toRoutingTableGroups(entry.getKey(), actualTableGroups);
            result.getTableUnits().getTableUnits().addAll(this.getTableUnits(entry.getKey(), Sets.cartesianProduct(routingTableGroups)).getTableUnits());
        }
        return result;
    }

    private Map<String, Set<String>> getDataSourceLogicTablesMap() {
        Collection<String> intersectionDataSources = this.getIntersectionDataSources();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(this.routingResults.size());
        for (RoutingResult each : this.routingResults) {
            for (Map.Entry<String, Set<String>> entry : each.getTableUnits().getDataSourceLogicTablesMap(intersectionDataSources).entrySet()) {
                if (result.containsKey(entry.getKey())) {
                    ((Set)result.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private Collection<String> getIntersectionDataSources() {
        HashSet<String> result = new HashSet<String>();
        for (RoutingResult each : this.routingResults) {
            if (result.isEmpty()) {
                result.addAll(each.getTableUnits().getDataSourceNames());
            }
            result.retainAll(each.getTableUnits().getDataSourceNames());
        }
        return result;
    }

    private List<Set<String>> getActualTableGroups(String dataSource, Set<String> logicTables) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>(logicTables.size());
        for (RoutingResult each : this.routingResults) {
            result.addAll(each.getTableUnits().getActualTableNameGroups(dataSource, logicTables));
        }
        return result;
    }

    private List<Set<RoutingTable>> toRoutingTableGroups(final String dataSource, List<Set<String>> actualTableGroups) {
        ArrayList<Set<RoutingTable>> result = new ArrayList<Set<RoutingTable>>(actualTableGroups.size());
        for (Set<String> each : actualTableGroups) {
            result.add(new HashSet(Lists.transform(new ArrayList<String>(each), (Function)new Function<String, RoutingTable>(){

                public RoutingTable apply(String input) {
                    return CartesianRoutingEngine.this.findRoutingTable(dataSource, input);
                }
            })));
        }
        return result;
    }

    private RoutingTable findRoutingTable(String dataSource, String actualTable) {
        for (RoutingResult each : this.routingResults) {
            Optional<RoutingTable> result = each.getTableUnits().findRoutingTable(dataSource, actualTable);
            if (!result.isPresent()) continue;
            return (RoutingTable)result.get();
        }
        throw new IllegalStateException(String.format("Cannot found routing table factor, data source: %s, actual table: %s", dataSource, actualTable));
    }

    private TableUnits getTableUnits(String dataSource, Set<List<RoutingTable>> cartesianRoutingTableGroups) {
        TableUnits result = new TableUnits();
        for (List<RoutingTable> each : cartesianRoutingTableGroups) {
            TableUnit tableUnit = new TableUnit(dataSource);
            tableUnit.getRoutingTables().addAll(each);
            result.getTableUnits().add(tableUnit);
        }
        return result;
    }

    @ConstructorProperties(value={"routingResults"})
    public CartesianRoutingEngine(Collection<RoutingResult> routingResults) {
        this.routingResults = routingResults;
    }
}

