/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.util;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.shardingsphere.core.executor.ShardingThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class ShardingExecutorService {
    private static final String DEFAULT_NAME_FORMAT = "%d";
    private static final ExecutorService SHUTDOWN_EXECUTOR = Executors.newSingleThreadExecutor(ShardingThreadFactoryBuilder.build("Executor-Engine-Closer"));
    private ListeningExecutorService executorService;

    public ShardingExecutorService(int executorSize, String nameFormat) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)(0 == executorSize ? Executors.newCachedThreadPool(ShardingThreadFactoryBuilder.build(nameFormat)) : Executors.newFixedThreadPool(executorSize, ShardingThreadFactoryBuilder.build(nameFormat))));
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public ShardingExecutorService(int executorSize) {
        this(executorSize, DEFAULT_NAME_FORMAT);
    }

    public void close() {
        SHUTDOWN_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ShardingExecutorService.this.executorService.shutdown();
                    while (!ShardingExecutorService.this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        ShardingExecutorService.this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    private ShardingExecutorService(ListeningExecutorService executorService) {
        this.executorService = executorService;
    }

    public ListeningExecutorService getExecutorService() {
        return this.executorService;
    }
}

