/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.adapter;

import io.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteCallback;
import io.shardingsphere.shardingjdbc.jdbc.adapter.executor.ForceExecuteTemplate;
import io.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationStatement;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;

public abstract class AbstractStatementAdapter
extends AbstractUnsupportedOperationStatement {
    private final Class<? extends Statement> targetClass;
    private boolean closed;
    private boolean poolable;
    private int fetchSize;
    private final ForceExecuteTemplate<Statement> forceExecuteTemplate = new ForceExecuteTemplate();

    @Override
    public final void close() throws SQLException {
        this.closed = true;
        try {
            this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

                @Override
                public void execute(Statement statement) throws SQLException {
                    statement.close();
                }
            });
        }
        finally {
            this.getRoutedStatements().clear();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isPoolable() {
        return this.poolable;
    }

    @Override
    public final void setPoolable(final boolean poolable) throws SQLException {
        this.poolable = poolable;
        this.recordMethodInvocation(this.targetClass, "setPoolable", new Class[]{Boolean.TYPE}, new Object[]{poolable});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setPoolable(poolable);
            }
        });
    }

    @Override
    public final int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public final void setFetchSize(final int rows) throws SQLException {
        this.fetchSize = rows;
        this.recordMethodInvocation(this.targetClass, "setFetchSize", new Class[]{Integer.TYPE}, new Object[]{rows});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setFetchSize(rows);
            }
        });
    }

    @Override
    public final void setEscapeProcessing(final boolean enable) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setEscapeProcessing", new Class[]{Boolean.TYPE}, new Object[]{enable});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setEscapeProcessing(enable);
            }
        });
    }

    @Override
    public final void cancel() throws SQLException {
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.cancel();
            }
        });
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        long result = 0L;
        boolean hasResult = false;
        for (Statement statement : this.getRoutedStatements()) {
            int updateCount = statement.getUpdateCount();
            if (updateCount > -1) {
                hasResult = true;
            }
            result += (long)updateCount;
        }
        if (result > Integer.MAX_VALUE) {
            result = Integer.MAX_VALUE;
        }
        return hasResult ? Long.valueOf(result).intValue() : -1;
    }

    @Override
    public final SQLWarning getWarnings() {
        return null;
    }

    @Override
    public final void clearWarnings() {
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        boolean result = false;
        for (Statement statement : this.getRoutedStatements()) {
            result = statement.getMoreResults();
        }
        return result;
    }

    @Override
    public final boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getMaxFieldSize();
    }

    @Override
    public final void setMaxFieldSize(final int max) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setMaxFieldSize", new Class[]{Integer.TYPE}, new Object[]{max});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setMaxFieldSize(max);
            }
        });
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? -1 : this.getRoutedStatements().iterator().next().getMaxRows();
    }

    @Override
    public final void setMaxRows(final int max) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setMaxRows", new Class[]{Integer.TYPE}, new Object[]{max});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setMaxRows(max);
            }
        });
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getRoutedStatements().isEmpty() ? 0 : this.getRoutedStatements().iterator().next().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(final int seconds) throws SQLException {
        this.recordMethodInvocation(this.targetClass, "setQueryTimeout", new Class[]{Integer.TYPE}, new Object[]{seconds});
        this.forceExecuteTemplate.execute(this.getRoutedStatements(), new ForceExecuteCallback<Statement>(){

            @Override
            public void execute(Statement statement) throws SQLException {
                statement.setQueryTimeout(seconds);
            }
        });
    }

    protected abstract Collection<? extends Statement> getRoutedStatements();

    @ConstructorProperties(value={"targetClass"})
    public AbstractStatementAdapter(Class<? extends Statement> targetClass) {
        this.targetClass = targetClass;
    }
}

