/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.connection;

import io.shardingsphere.core.constant.transaction.TransactionType;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractConnectionAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import io.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingPreparedStatement;
import io.shardingsphere.shardingjdbc.jdbc.core.statement.ShardingStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingContext shardingContext;

    public ShardingConnection(Map<String, DataSource> dataSourceMap, ShardingContext shardingContext, TransactionType transactionType) {
        super(transactionType);
        this.dataSourceMap = dataSourceMap;
        this.shardingContext = shardingContext;
    }

    void release(Connection connection) {
        this.removeCache(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Collection masterSlaveRules = this.shardingContext.getShardingRule().getMasterSlaveRules();
        if (masterSlaveRules.isEmpty()) {
            return this.getConnection(this.dataSourceMap.keySet().iterator().next()).getMetaData();
        }
        for (MasterSlaveRule each : masterSlaveRules) {
            if (!this.getDataSourceMap().containsKey(each.getMasterDataSourceName())) continue;
            return this.getConnection(each.getMasterDataSourceName()).getMetaData();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

