/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.collector.CollectorMetrics;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.Callback;

public abstract class Collector<D, S> {
    protected final Logger logger;
    protected final CollectorMetrics metrics;

    protected Collector(Logger logger, @Nullable CollectorMetrics metrics) {
        this.logger = Util.checkNotNull(logger, "logger");
        this.metrics = metrics == null ? CollectorMetrics.NOOP_METRICS : metrics;
    }

    protected abstract List<S> decodeList(D var1, byte[] var2);

    protected abstract boolean isSampled(S var1);

    protected abstract void record(List<S> var1, Callback<Void> var2);

    protected abstract String idString(S var1);

    boolean shouldWarn() {
        return this.logger.isLoggable(Level.FINE);
    }

    void warn(String message, Throwable e) {
        this.logger.log(Level.FINE, message, e);
    }

    protected void acceptSpans(byte[] serializedSpans, D decoder, Callback<Void> callback) {
        List<S> spans;
        this.metrics.incrementBytes(serializedSpans.length);
        try {
            spans = this.decodeList(decoder, serializedSpans);
        }
        catch (RuntimeException e) {
            callback.onError(this.errorReading(e));
            return;
        }
        this.accept(spans, callback);
    }

    public void accept(List<S> spans, Callback<Void> callback) {
        if (spans.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        this.metrics.incrementSpans(spans.size());
        List<S> sampled = this.sample(spans);
        if (sampled.isEmpty()) {
            callback.onSuccess(null);
            return;
        }
        try {
            this.record(sampled, this.acceptSpansCallback(sampled));
            callback.onSuccess(null);
        }
        catch (RuntimeException e) {
            callback.onError(this.errorStoringSpans(sampled, e));
            return;
        }
    }

    List<S> sample(List<S> input) {
        ArrayList<S> sampled = new ArrayList<S>(input.size());
        for (S s : input) {
            if (!this.isSampled(s)) continue;
            sampled.add(s);
        }
        int dropped = input.size() - sampled.size();
        if (dropped > 0) {
            this.metrics.incrementSpansDropped(dropped);
        }
        return sampled;
    }

    Callback<Void> acceptSpansCallback(final List<S> spans) {
        return new Callback<Void>(){

            @Override
            public void onSuccess(@Nullable Void value) {
            }

            @Override
            public void onError(Throwable t) {
                Collector.this.errorStoringSpans(spans, t);
            }

            public String toString() {
                return Collector.this.appendSpanIds(spans, new StringBuilder("AcceptSpans(")).append(")").toString();
            }
        };
    }

    protected RuntimeException errorReading(Throwable e) {
        return this.errorReading("Cannot decode spans", e);
    }

    RuntimeException errorReading(String message, Throwable e) {
        this.metrics.incrementMessagesDropped();
        return this.doError(message, e);
    }

    RuntimeException errorStoringSpans(List<S> spans, Throwable e) {
        this.metrics.incrementSpansDropped(spans.size());
        StringBuilder msg = this.appendSpanIds(spans, new StringBuilder("Cannot store spans "));
        return this.doError(msg.toString(), e);
    }

    RuntimeException doError(String message, Throwable e) {
        String error;
        String string = error = e.getMessage() != null ? e.getMessage() : "";
        if (e instanceof RuntimeException && error.startsWith("Malformed")) {
            if (this.shouldWarn()) {
                this.warn(error, e);
            }
            return (RuntimeException)e;
        }
        if (this.shouldWarn()) {
            message = String.format("%s due to %s(%s)", message, e.getClass().getSimpleName(), error);
            this.warn(message, e);
        }
        return new RuntimeException(message, e);
    }

    StringBuilder appendSpanIds(List<S> spans, StringBuilder message) {
        message.append("[");
        int i = 0;
        Iterator<S> iterator = spans.iterator();
        while (iterator.hasNext() && i++ < 3) {
            message.append(this.idString(iterator.next()));
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        if (iterator.hasNext()) {
            message.append("...");
        }
        return message.append("]");
    }
}

